<?php

namespace EnumType;

/**
 * This class stands for ModalitaPagamento EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModalitaPagamento
 * @subpackage Enumerations
 */
class ModalitaPagamento
{
    /**
     * Constant for value 'SulNodo'
     * @return string 'SulNodo'
     */
    const VALUE_SUL_NODO = 'SulNodo';
    /**
     * Constant for value 'FuoriNodoPos'
     * @return string 'FuoriNodoPos'
     */
    const VALUE_FUORI_NODO_POS = 'FuoriNodoPos';
    /**
     * Constant for value 'FuoriNodoBollettino'
     * @return string 'FuoriNodoBollettino'
     */
    const VALUE_FUORI_NODO_BOLLETTINO = 'FuoriNodoBollettino';
    /**
     * Constant for value 'FuoriNodoContanti'
     * @return string 'FuoriNodoContanti'
     */
    const VALUE_FUORI_NODO_CONTANTI = 'FuoriNodoContanti';
    /**
     * Constant for value 'BBT'
     * @return string 'BBT'
     */
    const VALUE_BBT = 'BBT';
    /**
     * Constant for value 'BP'
     * @return string 'BP'
     */
    const VALUE_BP = 'BP';
    /**
     * Constant for value 'AD'
     * @return string 'AD'
     */
    const VALUE_AD = 'AD';
    /**
     * Constant for value 'CP'
     * @return string 'CP'
     */
    const VALUE_CP = 'CP';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'OBEP'
     * @return string 'OBEP'
     */
    const VALUE_OBEP = 'OBEP';
    /**
     * Constant for value 'FuoriNodoBonifico'
     * @return string 'FuoriNodoBonifico'
     */
    const VALUE_FUORI_NODO_BONIFICO = 'FuoriNodoBonifico';
    /**
     * Constant for value 'FuoriNodoAssegno'
     * @return string 'FuoriNodoAssegno'
     */
    const VALUE_FUORI_NODO_ASSEGNO = 'FuoriNodoAssegno';
    /**
     * Constant for value 'FuoriNodoAltro'
     * @return string 'FuoriNodoAltro'
     */
    const VALUE_FUORI_NODO_ALTRO = 'FuoriNodoAltro';
    /**
     * Constant for value 'FuoriNodoPosNexi'
     * @return string 'FuoriNodoPosNexi'
     */
    const VALUE_FUORI_NODO_POS_NEXI = 'FuoriNodoPosNexi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUL_NODO
     * @uses self::VALUE_FUORI_NODO_POS
     * @uses self::VALUE_FUORI_NODO_BOLLETTINO
     * @uses self::VALUE_FUORI_NODO_CONTANTI
     * @uses self::VALUE_BBT
     * @uses self::VALUE_BP
     * @uses self::VALUE_AD
     * @uses self::VALUE_CP
     * @uses self::VALUE_PO
     * @uses self::VALUE_OBEP
     * @uses self::VALUE_FUORI_NODO_BONIFICO
     * @uses self::VALUE_FUORI_NODO_ASSEGNO
     * @uses self::VALUE_FUORI_NODO_ALTRO
     * @uses self::VALUE_FUORI_NODO_POS_NEXI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUL_NODO,
            self::VALUE_FUORI_NODO_POS,
            self::VALUE_FUORI_NODO_BOLLETTINO,
            self::VALUE_FUORI_NODO_CONTANTI,
            self::VALUE_BBT,
            self::VALUE_BP,
            self::VALUE_AD,
            self::VALUE_CP,
            self::VALUE_PO,
            self::VALUE_OBEP,
            self::VALUE_FUORI_NODO_BONIFICO,
            self::VALUE_FUORI_NODO_ASSEGNO,
            self::VALUE_FUORI_NODO_ALTRO,
            self::VALUE_FUORI_NODO_POS_NEXI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
