<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCUpdateCustomerNotepadRequest StructType
 * @subpackage Structs
 */
class WCUpdateCustomerNotepadRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - documentation: ID of the customer record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The notepad
     * Meta informations extracted from the WSDL
     * - documentation: Text of the notepad record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $notepad;
    /**
     * Constructor method for WCUpdateCustomerNotepadRequest
     * @uses WCUpdateCustomerNotepadRequest::setI_customer()
     * @uses WCUpdateCustomerNotepadRequest::setNotepad()
     * @param int $i_customer
     * @param string $notepad
     */
    public function __construct($i_customer = null, $notepad = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setNotepad($notepad);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\WCUpdateCustomerNotepadRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get notepad value
     * @return string
     */
    public function getNotepad()
    {
        return $this->notepad;
    }
    /**
     * Set notepad value
     * @param string $notepad
     * @return \StructType\WCUpdateCustomerNotepadRequest
     */
    public function setNotepad($notepad = null)
    {
        // validation for constraint: string
        if (!is_null($notepad) && !is_string($notepad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notepad)), __LINE__);
        }
        $this->notepad = $notepad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCUpdateCustomerNotepadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
