<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCUpdateAccountNotepadRequest StructType
 * @subpackage Structs
 */
class WCUpdateAccountNotepadRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - documentation: ID of the account record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_account;
    /**
     * The notepad
     * Meta informations extracted from the WSDL
     * - documentation: Text of the notepad record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $notepad;
    /**
     * Constructor method for WCUpdateAccountNotepadRequest
     * @uses WCUpdateAccountNotepadRequest::setI_account()
     * @uses WCUpdateAccountNotepadRequest::setNotepad()
     * @param int $i_account
     * @param string $notepad
     */
    public function __construct($i_account = null, $notepad = null)
    {
        $this
            ->setI_account($i_account)
            ->setNotepad($notepad);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\WCUpdateAccountNotepadRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get notepad value
     * @return string
     */
    public function getNotepad()
    {
        return $this->notepad;
    }
    /**
     * Set notepad value
     * @param string $notepad
     * @return \StructType\WCUpdateAccountNotepadRequest
     */
    public function setNotepad($notepad = null)
    {
        // validation for constraint: string
        if (!is_null($notepad) && !is_string($notepad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notepad)), __LINE__);
        }
        $this->notepad = $notepad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCUpdateAccountNotepadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
