<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCSubscriptionFeeRate StructType
 * @subpackage Structs
 */
class WCSubscriptionFeeRate extends AbstractStructBase
{
    /**
     * The monthly
     * Meta informations extracted from the WSDL
     * - documentation: Fee applied to customers with Monthly billing period
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\WCSubscriptionFee
     */
    public $monthly;
    /**
     * The biweekly
     * Meta informations extracted from the WSDL
     * - documentation: Fee applied to customers with Bi-weekly billing period
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\WCSubscriptionFee
     */
    public $biweekly;
    /**
     * The weekly
     * Meta informations extracted from the WSDL
     * - documentation: Fee applied to customers with Weekly billing period
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\WCSubscriptionFee
     */
    public $weekly;
    /**
     * The daily
     * Meta informations extracted from the WSDL
     * - documentation: Fee applied to customers with Daily billing period
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\WCSubscriptionFee
     */
    public $daily;
    /**
     * Constructor method for WCSubscriptionFeeRate
     * @uses WCSubscriptionFeeRate::setMonthly()
     * @uses WCSubscriptionFeeRate::setBiweekly()
     * @uses WCSubscriptionFeeRate::setWeekly()
     * @uses WCSubscriptionFeeRate::setDaily()
     * @param \StructType\WCSubscriptionFee $monthly
     * @param \StructType\WCSubscriptionFee $biweekly
     * @param \StructType\WCSubscriptionFee $weekly
     * @param \StructType\WCSubscriptionFee $daily
     */
    public function __construct(\StructType\WCSubscriptionFee $monthly = null, \StructType\WCSubscriptionFee $biweekly = null, \StructType\WCSubscriptionFee $weekly = null, \StructType\WCSubscriptionFee $daily = null)
    {
        $this
            ->setMonthly($monthly)
            ->setBiweekly($biweekly)
            ->setWeekly($weekly)
            ->setDaily($daily);
    }
    /**
     * Get monthly value
     * @return \StructType\WCSubscriptionFee
     */
    public function getMonthly()
    {
        return $this->monthly;
    }
    /**
     * Set monthly value
     * @param \StructType\WCSubscriptionFee $monthly
     * @return \StructType\WCSubscriptionFeeRate
     */
    public function setMonthly(\StructType\WCSubscriptionFee $monthly = null)
    {
        $this->monthly = $monthly;
        return $this;
    }
    /**
     * Get biweekly value
     * @return \StructType\WCSubscriptionFee
     */
    public function getBiweekly()
    {
        return $this->biweekly;
    }
    /**
     * Set biweekly value
     * @param \StructType\WCSubscriptionFee $biweekly
     * @return \StructType\WCSubscriptionFeeRate
     */
    public function setBiweekly(\StructType\WCSubscriptionFee $biweekly = null)
    {
        $this->biweekly = $biweekly;
        return $this;
    }
    /**
     * Get weekly value
     * @return \StructType\WCSubscriptionFee
     */
    public function getWeekly()
    {
        return $this->weekly;
    }
    /**
     * Set weekly value
     * @param \StructType\WCSubscriptionFee $weekly
     * @return \StructType\WCSubscriptionFeeRate
     */
    public function setWeekly(\StructType\WCSubscriptionFee $weekly = null)
    {
        $this->weekly = $weekly;
        return $this;
    }
    /**
     * Get daily value
     * @return \StructType\WCSubscriptionFee
     */
    public function getDaily()
    {
        return $this->daily;
    }
    /**
     * Set daily value
     * @param \StructType\WCSubscriptionFee $daily
     * @return \StructType\WCSubscriptionFeeRate
     */
    public function setDaily(\StructType\WCSubscriptionFee $daily = null)
    {
        $this->daily = $daily;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCSubscriptionFeeRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
