<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCSubscriptionFee StructType
 * @subpackage Structs
 */
class WCSubscriptionFee extends AbstractStructBase
{
    /**
     * The interval
     * Meta informations extracted from the WSDL
     * - documentation: Effective time interval: 0 - Default rate, N - Promotion span - the number of billing periods covered by this fee
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $interval;
    /**
     * The fee
     * Meta informations extracted from the WSDL
     * - documentation: Amount of the fee
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var float
     */
    public $fee;
    /**
     * The i_subscription_fee
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the subscription fee record
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_subscription_fee;
    /**
     * Constructor method for WCSubscriptionFee
     * @uses WCSubscriptionFee::setInterval()
     * @uses WCSubscriptionFee::setFee()
     * @uses WCSubscriptionFee::setI_subscription_fee()
     * @param int $interval
     * @param float $fee
     * @param int $i_subscription_fee
     */
    public function __construct($interval = null, $fee = null, $i_subscription_fee = null)
    {
        $this
            ->setInterval($interval)
            ->setFee($fee)
            ->setI_subscription_fee($i_subscription_fee);
    }
    /**
     * Get interval value
     * @return int
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param int $interval
     * @return \StructType\WCSubscriptionFee
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: int
        if (!is_null($interval) && !is_numeric($interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interval)), __LINE__);
        }
        $this->interval = $interval;
        return $this;
    }
    /**
     * Get fee value
     * @return float
     */
    public function getFee()
    {
        return $this->fee;
    }
    /**
     * Set fee value
     * @param float $fee
     * @return \StructType\WCSubscriptionFee
     */
    public function setFee($fee = null)
    {
        $this->fee = $fee;
        return $this;
    }
    /**
     * Get i_subscription_fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_subscription_fee()
    {
        return isset($this->i_subscription_fee) ? $this->i_subscription_fee : null;
    }
    /**
     * Set i_subscription_fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_subscription_fee
     * @return \StructType\WCSubscriptionFee
     */
    public function setI_subscription_fee($i_subscription_fee = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscription_fee) && !is_numeric($i_subscription_fee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscription_fee)), __LINE__);
        }
        if (is_null($i_subscription_fee) || (is_array($i_subscription_fee) && empty($i_subscription_fee))) {
            unset($this->i_subscription_fee);
        } else {
            $this->i_subscription_fee = $i_subscription_fee;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCSubscriptionFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
