<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetSubscriptionsRequest StructType
 * @subpackage Structs
 */
class WCGetSubscriptionsRequest extends AbstractStructBase
{
    /**
     * The object_type
     * Meta informations extracted from the WSDL
     * - documentation: Object type: customer, account
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $object_type;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: The offset of the first record to return (starting from 0)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - documentation: The maximum number of records to return, mandatory if the limit is specified
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * Constructor method for WCGetSubscriptionsRequest
     * @uses WCGetSubscriptionsRequest::setObject_type()
     * @uses WCGetSubscriptionsRequest::setOffset()
     * @uses WCGetSubscriptionsRequest::setLimit()
     * @param string $object_type
     * @param int $offset
     * @param int $limit
     */
    public function __construct($object_type = null, $offset = null, $limit = null)
    {
        $this
            ->setObject_type($object_type)
            ->setOffset($offset)
            ->setLimit($limit);
    }
    /**
     * Get object_type value
     * @return string
     */
    public function getObject_type()
    {
        return $this->object_type;
    }
    /**
     * Set object_type value
     * @param string $object_type
     * @return \StructType\WCGetSubscriptionsRequest
     */
    public function setObject_type($object_type = null)
    {
        // validation for constraint: string
        if (!is_null($object_type) && !is_string($object_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object_type)), __LINE__);
        }
        $this->object_type = $object_type;
        return $this;
    }
    /**
     * Get offset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffset()
    {
        return isset($this->offset) ? $this->offset : null;
    }
    /**
     * Set offset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offset
     * @return \StructType\WCGetSubscriptionsRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        if (is_null($offset) || (is_array($offset) && empty($offset))) {
            unset($this->offset);
        } else {
            $this->offset = $offset;
        }
        return $this;
    }
    /**
     * Get limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->limit) ? $this->limit : null;
    }
    /**
     * Set limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\WCGetSubscriptionsRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->limit);
        } else {
            $this->limit = $limit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetSubscriptionsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
