<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VDThresholdInfo StructType
 * @subpackage Structs
 */
class VDThresholdInfo extends AbstractStructBase
{
    /**
     * The i_vd_threshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_vd_threshold;
    /**
     * The i_vd_dg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_vd_dg;
    /**
     * The notify_if_exceeded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notify_if_exceeded;
    /**
     * The alter_service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $alter_service;
    /**
     * The threshold_value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $threshold_value;
    /**
     * The discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount;
    /**
     * The xdr_split
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $xdr_split;
    /**
     * Constructor method for VDThresholdInfo
     * @uses VDThresholdInfo::setI_vd_threshold()
     * @uses VDThresholdInfo::setI_vd_dg()
     * @uses VDThresholdInfo::setNotify_if_exceeded()
     * @uses VDThresholdInfo::setAlter_service()
     * @uses VDThresholdInfo::setThreshold_value()
     * @uses VDThresholdInfo::setDiscount()
     * @uses VDThresholdInfo::setXdr_split()
     * @param int $i_vd_threshold
     * @param int $i_vd_dg
     * @param string $notify_if_exceeded
     * @param string $alter_service
     * @param float $threshold_value
     * @param float $discount
     * @param string $xdr_split
     */
    public function __construct($i_vd_threshold = null, $i_vd_dg = null, $notify_if_exceeded = null, $alter_service = null, $threshold_value = null, $discount = null, $xdr_split = null)
    {
        $this
            ->setI_vd_threshold($i_vd_threshold)
            ->setI_vd_dg($i_vd_dg)
            ->setNotify_if_exceeded($notify_if_exceeded)
            ->setAlter_service($alter_service)
            ->setThreshold_value($threshold_value)
            ->setDiscount($discount)
            ->setXdr_split($xdr_split);
    }
    /**
     * Get i_vd_threshold value
     * @return int|null
     */
    public function getI_vd_threshold()
    {
        return $this->i_vd_threshold;
    }
    /**
     * Set i_vd_threshold value
     * @param int $i_vd_threshold
     * @return \StructType\VDThresholdInfo
     */
    public function setI_vd_threshold($i_vd_threshold = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_threshold) && !is_numeric($i_vd_threshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_threshold)), __LINE__);
        }
        $this->i_vd_threshold = $i_vd_threshold;
        return $this;
    }
    /**
     * Get i_vd_dg value
     * @return int|null
     */
    public function getI_vd_dg()
    {
        return $this->i_vd_dg;
    }
    /**
     * Set i_vd_dg value
     * @param int $i_vd_dg
     * @return \StructType\VDThresholdInfo
     */
    public function setI_vd_dg($i_vd_dg = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_dg) && !is_numeric($i_vd_dg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_dg)), __LINE__);
        }
        $this->i_vd_dg = $i_vd_dg;
        return $this;
    }
    /**
     * Get notify_if_exceeded value
     * @return string|null
     */
    public function getNotify_if_exceeded()
    {
        return $this->notify_if_exceeded;
    }
    /**
     * Set notify_if_exceeded value
     * @param string $notify_if_exceeded
     * @return \StructType\VDThresholdInfo
     */
    public function setNotify_if_exceeded($notify_if_exceeded = null)
    {
        // validation for constraint: string
        if (!is_null($notify_if_exceeded) && !is_string($notify_if_exceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notify_if_exceeded)), __LINE__);
        }
        $this->notify_if_exceeded = $notify_if_exceeded;
        return $this;
    }
    /**
     * Get alter_service value
     * @return string|null
     */
    public function getAlter_service()
    {
        return $this->alter_service;
    }
    /**
     * Set alter_service value
     * @param string $alter_service
     * @return \StructType\VDThresholdInfo
     */
    public function setAlter_service($alter_service = null)
    {
        // validation for constraint: string
        if (!is_null($alter_service) && !is_string($alter_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alter_service)), __LINE__);
        }
        $this->alter_service = $alter_service;
        return $this;
    }
    /**
     * Get threshold_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getThreshold_value()
    {
        return isset($this->threshold_value) ? $this->threshold_value : null;
    }
    /**
     * Set threshold_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $threshold_value
     * @return \StructType\VDThresholdInfo
     */
    public function setThreshold_value($threshold_value = null)
    {
        if (is_null($threshold_value) || (is_array($threshold_value) && empty($threshold_value))) {
            unset($this->threshold_value);
        } else {
            $this->threshold_value = $threshold_value;
        }
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \StructType\VDThresholdInfo
     */
    public function setDiscount($discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get xdr_split value
     * @return string|null
     */
    public function getXdr_split()
    {
        return $this->xdr_split;
    }
    /**
     * Set xdr_split value
     * @param string $xdr_split
     * @return \StructType\VDThresholdInfo
     */
    public function setXdr_split($xdr_split = null)
    {
        // validation for constraint: string
        if (!is_null($xdr_split) && !is_string($xdr_split)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($xdr_split)), __LINE__);
        }
        $this->xdr_split = $xdr_split;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VDThresholdInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
