<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerCustomFieldsValuesRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerCustomFieldsValuesRequest extends AbstractStructBase
{
    /**
     * The custom_fields_values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:CustomFieldsValuesInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomFieldsValuesInfo[]
     */
    public $custom_fields_values;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * Constructor method for UpdateCustomerCustomFieldsValuesRequest
     * @uses UpdateCustomerCustomFieldsValuesRequest::setCustom_fields_values()
     * @uses UpdateCustomerCustomFieldsValuesRequest::setI_customer()
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     * @param int $i_customer
     */
    public function __construct(array $custom_fields_values = array(), $i_customer = null)
    {
        $this
            ->setCustom_fields_values($custom_fields_values)
            ->setI_customer($i_customer);
    }
    /**
     * Get custom_fields_values value
     * @return \StructType\CustomFieldsValuesInfo[]
     */
    public function getCustom_fields_values()
    {
        return $this->custom_fields_values;
    }
    /**
     * Set custom_fields_values value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     * @return \StructType\UpdateCustomerCustomFieldsValuesRequest
     */
    public function setCustom_fields_values(array $custom_fields_values = array())
    {
        foreach ($custom_fields_values as $updateCustomerCustomFieldsValuesRequestCustom_fields_valuesItem) {
            // validation for constraint: itemType
            if (!$updateCustomerCustomFieldsValuesRequestCustom_fields_valuesItem instanceof \StructType\CustomFieldsValuesInfo) {
                throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($updateCustomerCustomFieldsValuesRequestCustom_fields_valuesItem) ? get_class($updateCustomerCustomFieldsValuesRequestCustom_fields_valuesItem) : gettype($updateCustomerCustomFieldsValuesRequestCustom_fields_valuesItem)), __LINE__);
            }
        }
        $this->custom_fields_values = $custom_fields_values;
        return $this;
    }
    /**
     * Add item to custom_fields_values value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo $item
     * @return \StructType\UpdateCustomerCustomFieldsValuesRequest
     */
    public function addToCustom_fields_values(\StructType\CustomFieldsValuesInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldsValuesInfo) {
            throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->custom_fields_values[] = $item;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerCustomFieldsValuesRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerCustomFieldsValuesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
