<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountFollowMeRequest StructType
 * @subpackage Structs
 */
class UpdateAccountFollowMeRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The followme_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\FollowMeInfo
     */
    public $followme_info;
    /**
     * Constructor method for UpdateAccountFollowMeRequest
     * @uses UpdateAccountFollowMeRequest::setI_account()
     * @uses UpdateAccountFollowMeRequest::setFollowme_info()
     * @param int $i_account
     * @param \StructType\FollowMeInfo $followme_info
     */
    public function __construct($i_account = null, \StructType\FollowMeInfo $followme_info = null)
    {
        $this
            ->setI_account($i_account)
            ->setFollowme_info($followme_info);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\UpdateAccountFollowMeRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get followme_info value
     * @return \StructType\FollowMeInfo
     */
    public function getFollowme_info()
    {
        return $this->followme_info;
    }
    /**
     * Set followme_info value
     * @param \StructType\FollowMeInfo $followme_info
     * @return \StructType\UpdateAccountFollowMeRequest
     */
    public function setFollowme_info(\StructType\FollowMeInfo $followme_info = null)
    {
        $this->followme_info = $followme_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAccountFollowMeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
