<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInfo StructType
 * @subpackage Structs
 */
class TransactionInfo extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The cdrid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cdrid;
    /**
     * The details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $details;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The i_env
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_env;
    /**
     * The i_merchant_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_merchant_account;
    /**
     * The i_online_payment_processor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_online_payment_processor;
    /**
     * The i_payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_payment_method;
    /**
     * The i_payment_transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_payment_transaction;
    /**
     * The unique_transaction_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unique_transaction_id;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The payment_method_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payment_method_info;
    /**
     * The result_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $result_code;
    /**
     * The result_message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $result_message;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The test_mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $test_mode;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The x_transaction_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $x_transaction_id;
    /**
     * The secret
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secret;
    /**
     * Constructor method for TransactionInfo
     * @uses TransactionInfo::setAmount()
     * @uses TransactionInfo::setCdrid()
     * @uses TransactionInfo::setDetails()
     * @uses TransactionInfo::setI_account()
     * @uses TransactionInfo::setI_customer()
     * @uses TransactionInfo::setI_env()
     * @uses TransactionInfo::setI_merchant_account()
     * @uses TransactionInfo::setI_online_payment_processor()
     * @uses TransactionInfo::setI_payment_method()
     * @uses TransactionInfo::setI_payment_transaction()
     * @uses TransactionInfo::setUnique_transaction_id()
     * @uses TransactionInfo::setIso_4217()
     * @uses TransactionInfo::setPayment_method_info()
     * @uses TransactionInfo::setResult_code()
     * @uses TransactionInfo::setResult_message()
     * @uses TransactionInfo::setStatus()
     * @uses TransactionInfo::setTest_mode()
     * @uses TransactionInfo::setTimestamp()
     * @uses TransactionInfo::setX_transaction_id()
     * @uses TransactionInfo::setSecret()
     * @param float $amount
     * @param string $cdrid
     * @param string $details
     * @param int $i_account
     * @param int $i_customer
     * @param int $i_env
     * @param int $i_merchant_account
     * @param int $i_online_payment_processor
     * @param int $i_payment_method
     * @param int $i_payment_transaction
     * @param string $unique_transaction_id
     * @param string $iso_4217
     * @param string $payment_method_info
     * @param string $result_code
     * @param string $result_message
     * @param string $status
     * @param string $test_mode
     * @param string $timestamp
     * @param string $x_transaction_id
     * @param string $secret
     */
    public function __construct($amount = null, $cdrid = null, $details = null, $i_account = null, $i_customer = null, $i_env = null, $i_merchant_account = null, $i_online_payment_processor = null, $i_payment_method = null, $i_payment_transaction = null, $unique_transaction_id = null, $iso_4217 = null, $payment_method_info = null, $result_code = null, $result_message = null, $status = null, $test_mode = null, $timestamp = null, $x_transaction_id = null, $secret = null)
    {
        $this
            ->setAmount($amount)
            ->setCdrid($cdrid)
            ->setDetails($details)
            ->setI_account($i_account)
            ->setI_customer($i_customer)
            ->setI_env($i_env)
            ->setI_merchant_account($i_merchant_account)
            ->setI_online_payment_processor($i_online_payment_processor)
            ->setI_payment_method($i_payment_method)
            ->setI_payment_transaction($i_payment_transaction)
            ->setUnique_transaction_id($unique_transaction_id)
            ->setIso_4217($iso_4217)
            ->setPayment_method_info($payment_method_info)
            ->setResult_code($result_code)
            ->setResult_message($result_message)
            ->setStatus($status)
            ->setTest_mode($test_mode)
            ->setTimestamp($timestamp)
            ->setX_transaction_id($x_transaction_id)
            ->setSecret($secret);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\TransactionInfo
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get cdrid value
     * @return string|null
     */
    public function getCdrid()
    {
        return $this->cdrid;
    }
    /**
     * Set cdrid value
     * @param string $cdrid
     * @return \StructType\TransactionInfo
     */
    public function setCdrid($cdrid = null)
    {
        // validation for constraint: string
        if (!is_null($cdrid) && !is_string($cdrid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cdrid)), __LINE__);
        }
        $this->cdrid = $cdrid;
        return $this;
    }
    /**
     * Get details value
     * @return string|null
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param string $details
     * @return \StructType\TransactionInfo
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($details)), __LINE__);
        }
        $this->details = $details;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\TransactionInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\TransactionInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_env value
     * @return int|null
     */
    public function getI_env()
    {
        return $this->i_env;
    }
    /**
     * Set i_env value
     * @param int $i_env
     * @return \StructType\TransactionInfo
     */
    public function setI_env($i_env = null)
    {
        // validation for constraint: int
        if (!is_null($i_env) && !is_numeric($i_env)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_env)), __LINE__);
        }
        $this->i_env = $i_env;
        return $this;
    }
    /**
     * Get i_merchant_account value
     * @return int|null
     */
    public function getI_merchant_account()
    {
        return $this->i_merchant_account;
    }
    /**
     * Set i_merchant_account value
     * @param int $i_merchant_account
     * @return \StructType\TransactionInfo
     */
    public function setI_merchant_account($i_merchant_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_merchant_account) && !is_numeric($i_merchant_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_merchant_account)), __LINE__);
        }
        $this->i_merchant_account = $i_merchant_account;
        return $this;
    }
    /**
     * Get i_online_payment_processor value
     * @return int|null
     */
    public function getI_online_payment_processor()
    {
        return $this->i_online_payment_processor;
    }
    /**
     * Set i_online_payment_processor value
     * @param int $i_online_payment_processor
     * @return \StructType\TransactionInfo
     */
    public function setI_online_payment_processor($i_online_payment_processor = null)
    {
        // validation for constraint: int
        if (!is_null($i_online_payment_processor) && !is_numeric($i_online_payment_processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_online_payment_processor)), __LINE__);
        }
        $this->i_online_payment_processor = $i_online_payment_processor;
        return $this;
    }
    /**
     * Get i_payment_method value
     * @return int|null
     */
    public function getI_payment_method()
    {
        return $this->i_payment_method;
    }
    /**
     * Set i_payment_method value
     * @param int $i_payment_method
     * @return \StructType\TransactionInfo
     */
    public function setI_payment_method($i_payment_method = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_method) && !is_numeric($i_payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_method)), __LINE__);
        }
        $this->i_payment_method = $i_payment_method;
        return $this;
    }
    /**
     * Get i_payment_transaction value
     * @return int|null
     */
    public function getI_payment_transaction()
    {
        return $this->i_payment_transaction;
    }
    /**
     * Set i_payment_transaction value
     * @param int $i_payment_transaction
     * @return \StructType\TransactionInfo
     */
    public function setI_payment_transaction($i_payment_transaction = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_transaction) && !is_numeric($i_payment_transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_transaction)), __LINE__);
        }
        $this->i_payment_transaction = $i_payment_transaction;
        return $this;
    }
    /**
     * Get unique_transaction_id value
     * @return string|null
     */
    public function getUnique_transaction_id()
    {
        return $this->unique_transaction_id;
    }
    /**
     * Set unique_transaction_id value
     * @param string $unique_transaction_id
     * @return \StructType\TransactionInfo
     */
    public function setUnique_transaction_id($unique_transaction_id = null)
    {
        // validation for constraint: string
        if (!is_null($unique_transaction_id) && !is_string($unique_transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unique_transaction_id)), __LINE__);
        }
        $this->unique_transaction_id = $unique_transaction_id;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\TransactionInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get payment_method_info value
     * @return string|null
     */
    public function getPayment_method_info()
    {
        return $this->payment_method_info;
    }
    /**
     * Set payment_method_info value
     * @param string $payment_method_info
     * @return \StructType\TransactionInfo
     */
    public function setPayment_method_info($payment_method_info = null)
    {
        // validation for constraint: string
        if (!is_null($payment_method_info) && !is_string($payment_method_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_method_info)), __LINE__);
        }
        $this->payment_method_info = $payment_method_info;
        return $this;
    }
    /**
     * Get result_code value
     * @return string|null
     */
    public function getResult_code()
    {
        return $this->result_code;
    }
    /**
     * Set result_code value
     * @param string $result_code
     * @return \StructType\TransactionInfo
     */
    public function setResult_code($result_code = null)
    {
        // validation for constraint: string
        if (!is_null($result_code) && !is_string($result_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result_code)), __LINE__);
        }
        $this->result_code = $result_code;
        return $this;
    }
    /**
     * Get result_message value
     * @return string|null
     */
    public function getResult_message()
    {
        return $this->result_message;
    }
    /**
     * Set result_message value
     * @param string $result_message
     * @return \StructType\TransactionInfo
     */
    public function setResult_message($result_message = null)
    {
        // validation for constraint: string
        if (!is_null($result_message) && !is_string($result_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result_message)), __LINE__);
        }
        $this->result_message = $result_message;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TransactionInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get test_mode value
     * @return string|null
     */
    public function getTest_mode()
    {
        return $this->test_mode;
    }
    /**
     * Set test_mode value
     * @param string $test_mode
     * @return \StructType\TransactionInfo
     */
    public function setTest_mode($test_mode = null)
    {
        // validation for constraint: string
        if (!is_null($test_mode) && !is_string($test_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($test_mode)), __LINE__);
        }
        $this->test_mode = $test_mode;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\TransactionInfo
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get x_transaction_id value
     * @return string|null
     */
    public function getX_transaction_id()
    {
        return $this->x_transaction_id;
    }
    /**
     * Set x_transaction_id value
     * @param string $x_transaction_id
     * @return \StructType\TransactionInfo
     */
    public function setX_transaction_id($x_transaction_id = null)
    {
        // validation for constraint: string
        if (!is_null($x_transaction_id) && !is_string($x_transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($x_transaction_id)), __LINE__);
        }
        $this->x_transaction_id = $x_transaction_id;
        return $this;
    }
    /**
     * Get secret value
     * @return string|null
     */
    public function getSecret()
    {
        return $this->secret;
    }
    /**
     * Set secret value
     * @param string $secret
     * @return \StructType\TransactionInfo
     */
    public function setSecret($secret = null)
    {
        // validation for constraint: string
        if (!is_null($secret) && !is_string($secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secret)), __LINE__);
        }
        $this->secret = $secret;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
