<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeZoneInfo StructType
 * @subpackage Structs
 */
class TimeZoneInfo extends AbstractStructBase
{
    /**
     * The i_time_zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_time_zone;
    /**
     * The time_zone_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $time_zone_name;
    /**
     * Constructor method for TimeZoneInfo
     * @uses TimeZoneInfo::setI_time_zone()
     * @uses TimeZoneInfo::setTime_zone_name()
     * @param int $i_time_zone
     * @param string $time_zone_name
     */
    public function __construct($i_time_zone = null, $time_zone_name = null)
    {
        $this
            ->setI_time_zone($i_time_zone)
            ->setTime_zone_name($time_zone_name);
    }
    /**
     * Get i_time_zone value
     * @return int|null
     */
    public function getI_time_zone()
    {
        return $this->i_time_zone;
    }
    /**
     * Set i_time_zone value
     * @param int $i_time_zone
     * @return \StructType\TimeZoneInfo
     */
    public function setI_time_zone($i_time_zone = null)
    {
        // validation for constraint: int
        if (!is_null($i_time_zone) && !is_numeric($i_time_zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_time_zone)), __LINE__);
        }
        $this->i_time_zone = $i_time_zone;
        return $this;
    }
    /**
     * Get time_zone_name value
     * @return string|null
     */
    public function getTime_zone_name()
    {
        return $this->time_zone_name;
    }
    /**
     * Set time_zone_name value
     * @param string $time_zone_name
     * @return \StructType\TimeZoneInfo
     */
    public function setTime_zone_name($time_zone_name = null)
    {
        // validation for constraint: string
        if (!is_null($time_zone_name) && !is_string($time_zone_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_zone_name)), __LINE__);
        }
        $this->time_zone_name = $time_zone_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimeZoneInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
