<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubdivisionInfo StructType
 * @subpackage Structs
 */
class SubdivisionInfo extends AbstractStructBase
{
    /**
     * The i_country_subdivision
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_country_subdivision;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The iso_3166_1_a2
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $iso_3166_1_a2;
    /**
     * The iso_3166_2
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $iso_3166_2;
    /**
     * Constructor method for SubdivisionInfo
     * @uses SubdivisionInfo::setI_country_subdivision()
     * @uses SubdivisionInfo::setName()
     * @uses SubdivisionInfo::setIso_3166_1_a2()
     * @uses SubdivisionInfo::setIso_3166_2()
     * @param int $i_country_subdivision
     * @param string $name
     * @param string $iso_3166_1_a2
     * @param string $iso_3166_2
     */
    public function __construct($i_country_subdivision = null, $name = null, $iso_3166_1_a2 = null, $iso_3166_2 = null)
    {
        $this
            ->setI_country_subdivision($i_country_subdivision)
            ->setName($name)
            ->setIso_3166_1_a2($iso_3166_1_a2)
            ->setIso_3166_2($iso_3166_2);
    }
    /**
     * Get i_country_subdivision value
     * @return int
     */
    public function getI_country_subdivision()
    {
        return $this->i_country_subdivision;
    }
    /**
     * Set i_country_subdivision value
     * @param int $i_country_subdivision
     * @return \StructType\SubdivisionInfo
     */
    public function setI_country_subdivision($i_country_subdivision = null)
    {
        // validation for constraint: int
        if (!is_null($i_country_subdivision) && !is_numeric($i_country_subdivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_country_subdivision)), __LINE__);
        }
        $this->i_country_subdivision = $i_country_subdivision;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SubdivisionInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get iso_3166_1_a2 value
     * @return string
     */
    public function getIso_3166_1_a2()
    {
        return $this->iso_3166_1_a2;
    }
    /**
     * Set iso_3166_1_a2 value
     * @param string $iso_3166_1_a2
     * @return \StructType\SubdivisionInfo
     */
    public function setIso_3166_1_a2($iso_3166_1_a2 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_1_a2) && !is_string($iso_3166_1_a2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_1_a2)), __LINE__);
        }
        $this->iso_3166_1_a2 = $iso_3166_1_a2;
        return $this;
    }
    /**
     * Get iso_3166_2 value
     * @return string
     */
    public function getIso_3166_2()
    {
        return $this->iso_3166_2;
    }
    /**
     * Set iso_3166_2 value
     * @param string $iso_3166_2
     * @return \StructType\SubdivisionInfo
     */
    public function setIso_3166_2($iso_3166_2 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_2) && !is_string($iso_3166_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_2)), __LINE__);
        }
        $this->iso_3166_2 = $iso_3166_2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubdivisionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
