<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceInfo StructType
 * @subpackage Structs
 */
class ServiceInfo extends AbstractStructBase
{
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The rate_unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rate_unit;
    /**
     * The ratio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ratio;
    /**
     * The i_service_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service_type;
    /**
     * The rating_base
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rating_base;
    /**
     * The i_st_charge_unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_st_charge_unit;
    /**
     * Constructor method for ServiceInfo
     * @uses ServiceInfo::setI_service()
     * @uses ServiceInfo::setName()
     * @uses ServiceInfo::setUnit()
     * @uses ServiceInfo::setRate_unit()
     * @uses ServiceInfo::setRatio()
     * @uses ServiceInfo::setI_service_type()
     * @uses ServiceInfo::setRating_base()
     * @uses ServiceInfo::setI_st_charge_unit()
     * @param int $i_service
     * @param string $name
     * @param string $unit
     * @param string $rate_unit
     * @param int $ratio
     * @param int $i_service_type
     * @param string $rating_base
     * @param int $i_st_charge_unit
     */
    public function __construct($i_service = null, $name = null, $unit = null, $rate_unit = null, $ratio = null, $i_service_type = null, $rating_base = null, $i_st_charge_unit = null)
    {
        $this
            ->setI_service($i_service)
            ->setName($name)
            ->setUnit($unit)
            ->setRate_unit($rate_unit)
            ->setRatio($ratio)
            ->setI_service_type($i_service_type)
            ->setRating_base($rating_base)
            ->setI_st_charge_unit($i_st_charge_unit);
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\ServiceInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ServiceInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\ServiceInfo
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get rate_unit value
     * @return string|null
     */
    public function getRate_unit()
    {
        return $this->rate_unit;
    }
    /**
     * Set rate_unit value
     * @param string $rate_unit
     * @return \StructType\ServiceInfo
     */
    public function setRate_unit($rate_unit = null)
    {
        // validation for constraint: string
        if (!is_null($rate_unit) && !is_string($rate_unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rate_unit)), __LINE__);
        }
        $this->rate_unit = $rate_unit;
        return $this;
    }
    /**
     * Get ratio value
     * @return int|null
     */
    public function getRatio()
    {
        return $this->ratio;
    }
    /**
     * Set ratio value
     * @param int $ratio
     * @return \StructType\ServiceInfo
     */
    public function setRatio($ratio = null)
    {
        // validation for constraint: int
        if (!is_null($ratio) && !is_numeric($ratio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ratio)), __LINE__);
        }
        $this->ratio = $ratio;
        return $this;
    }
    /**
     * Get i_service_type value
     * @return int|null
     */
    public function getI_service_type()
    {
        return $this->i_service_type;
    }
    /**
     * Set i_service_type value
     * @param int $i_service_type
     * @return \StructType\ServiceInfo
     */
    public function setI_service_type($i_service_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_type) && !is_numeric($i_service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_type)), __LINE__);
        }
        $this->i_service_type = $i_service_type;
        return $this;
    }
    /**
     * Get rating_base value
     * @return string|null
     */
    public function getRating_base()
    {
        return $this->rating_base;
    }
    /**
     * Set rating_base value
     * @param string $rating_base
     * @return \StructType\ServiceInfo
     */
    public function setRating_base($rating_base = null)
    {
        // validation for constraint: string
        if (!is_null($rating_base) && !is_string($rating_base)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rating_base)), __LINE__);
        }
        $this->rating_base = $rating_base;
        return $this;
    }
    /**
     * Get i_st_charge_unit value
     * @return int|null
     */
    public function getI_st_charge_unit()
    {
        return $this->i_st_charge_unit;
    }
    /**
     * Set i_st_charge_unit value
     * @param int $i_st_charge_unit
     * @return \StructType\ServiceInfo
     */
    public function setI_st_charge_unit($i_st_charge_unit = null)
    {
        // validation for constraint: int
        if (!is_null($i_st_charge_unit) && !is_numeric($i_st_charge_unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_st_charge_unit)), __LINE__);
        }
        $this->i_st_charge_unit = $i_st_charge_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
