<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReserveDIDNumberRequest StructType
 * @subpackage Structs
 */
class ReserveDIDNumberRequest extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The reserve_term
     * @var int
     */
    public $reserve_term;
    /**
     * Constructor method for ReserveDIDNumberRequest
     * @uses ReserveDIDNumberRequest::setNumber()
     * @uses ReserveDIDNumberRequest::setReserve_term()
     * @param string $number
     * @param int $reserve_term
     */
    public function __construct($number = null, $reserve_term = null)
    {
        $this
            ->setNumber($number)
            ->setReserve_term($reserve_term);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\ReserveDIDNumberRequest
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get reserve_term value
     * @return int|null
     */
    public function getReserve_term()
    {
        return $this->reserve_term;
    }
    /**
     * Set reserve_term value
     * @param int $reserve_term
     * @return \StructType\ReserveDIDNumberRequest
     */
    public function setReserve_term($reserve_term = null)
    {
        // validation for constraint: int
        if (!is_null($reserve_term) && !is_numeric($reserve_term)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reserve_term)), __LINE__);
        }
        $this->reserve_term = $reserve_term;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReserveDIDNumberRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
