<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateInfo StructType
 * @subpackage Structs
 */
class RateInfo extends AbstractStructBase
{
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_tariff;
    /**
     * The interval_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $interval_1;
    /**
     * The interval_n
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $interval_n;
    /**
     * The price_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $price_1;
    /**
     * The price_n
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $price_n;
    /**
     * The op_interval_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $op_interval_1;
    /**
     * The op_interval_n
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $op_interval_n;
    /**
     * The op_price_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $op_price_1;
    /**
     * The op_price_n
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $op_price_n;
    /**
     * The i_dest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_dest;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The i_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_rate;
    /**
     * The i_offpeak
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_offpeak;
    /**
     * The effective_from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effective_from;
    /**
     * The inactive_from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inactive_from;
    /**
     * The effective_immediately
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effective_immediately;
    /**
     * The effective_now
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effective_now;
    /**
     * The hidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hidden;
    /**
     * The discontinued
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discontinued;
    /**
     * The forbidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $forbidden;
    /**
     * The preference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $preference;
    /**
     * The huntstop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $huntstop;
    /**
     * The formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formula;
    /**
     * The route_category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $route_category;
    /**
     * The op_route_category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $op_route_category;
    /**
     * The op_preference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $op_preference;
    /**
     * The op_huntstop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $op_huntstop;
    /**
     * The i_rate_formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_rate_formula;
    /**
     * The reverse_rating
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reverse_rating;
    /**
     * The special_price_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $special_price_1;
    /**
     * The special_price_n
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $special_price_n;
    /**
     * The i_dest_group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_dest_group;
    /**
     * The destination_group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination_group;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The editable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $editable;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * Constructor method for RateInfo
     * @uses RateInfo::setI_tariff()
     * @uses RateInfo::setInterval_1()
     * @uses RateInfo::setInterval_n()
     * @uses RateInfo::setPrice_1()
     * @uses RateInfo::setPrice_n()
     * @uses RateInfo::setOp_interval_1()
     * @uses RateInfo::setOp_interval_n()
     * @uses RateInfo::setOp_price_1()
     * @uses RateInfo::setOp_price_n()
     * @uses RateInfo::setI_dest()
     * @uses RateInfo::setDestination()
     * @uses RateInfo::setI_rate()
     * @uses RateInfo::setI_offpeak()
     * @uses RateInfo::setEffective_from()
     * @uses RateInfo::setInactive_from()
     * @uses RateInfo::setEffective_immediately()
     * @uses RateInfo::setEffective_now()
     * @uses RateInfo::setHidden()
     * @uses RateInfo::setDiscontinued()
     * @uses RateInfo::setForbidden()
     * @uses RateInfo::setPreference()
     * @uses RateInfo::setHuntstop()
     * @uses RateInfo::setFormula()
     * @uses RateInfo::setRoute_category()
     * @uses RateInfo::setOp_route_category()
     * @uses RateInfo::setOp_preference()
     * @uses RateInfo::setOp_huntstop()
     * @uses RateInfo::setI_rate_formula()
     * @uses RateInfo::setReverse_rating()
     * @uses RateInfo::setSpecial_price_1()
     * @uses RateInfo::setSpecial_price_n()
     * @uses RateInfo::setI_dest_group()
     * @uses RateInfo::setDestination_group()
     * @uses RateInfo::setDescription()
     * @uses RateInfo::setEditable()
     * @uses RateInfo::setCountry()
     * @param int $i_tariff
     * @param int $interval_1
     * @param int $interval_n
     * @param float $price_1
     * @param float $price_n
     * @param int $op_interval_1
     * @param int $op_interval_n
     * @param float $op_price_1
     * @param float $op_price_n
     * @param int $i_dest
     * @param string $destination
     * @param int $i_rate
     * @param int $i_offpeak
     * @param string $effective_from
     * @param string $inactive_from
     * @param string $effective_immediately
     * @param string $effective_now
     * @param string $hidden
     * @param string $discontinued
     * @param string $forbidden
     * @param int $preference
     * @param string $huntstop
     * @param string $formula
     * @param int $route_category
     * @param int $op_route_category
     * @param int $op_preference
     * @param string $op_huntstop
     * @param int $i_rate_formula
     * @param string $reverse_rating
     * @param float $special_price_1
     * @param float $special_price_n
     * @param int $i_dest_group
     * @param string $destination_group
     * @param string $description
     * @param string $editable
     * @param string $country
     */
    public function __construct($i_tariff = null, $interval_1 = null, $interval_n = null, $price_1 = null, $price_n = null, $op_interval_1 = null, $op_interval_n = null, $op_price_1 = null, $op_price_n = null, $i_dest = null, $destination = null, $i_rate = null, $i_offpeak = null, $effective_from = null, $inactive_from = null, $effective_immediately = null, $effective_now = null, $hidden = null, $discontinued = null, $forbidden = null, $preference = null, $huntstop = null, $formula = null, $route_category = null, $op_route_category = null, $op_preference = null, $op_huntstop = null, $i_rate_formula = null, $reverse_rating = null, $special_price_1 = null, $special_price_n = null, $i_dest_group = null, $destination_group = null, $description = null, $editable = null, $country = null)
    {
        $this
            ->setI_tariff($i_tariff)
            ->setInterval_1($interval_1)
            ->setInterval_n($interval_n)
            ->setPrice_1($price_1)
            ->setPrice_n($price_n)
            ->setOp_interval_1($op_interval_1)
            ->setOp_interval_n($op_interval_n)
            ->setOp_price_1($op_price_1)
            ->setOp_price_n($op_price_n)
            ->setI_dest($i_dest)
            ->setDestination($destination)
            ->setI_rate($i_rate)
            ->setI_offpeak($i_offpeak)
            ->setEffective_from($effective_from)
            ->setInactive_from($inactive_from)
            ->setEffective_immediately($effective_immediately)
            ->setEffective_now($effective_now)
            ->setHidden($hidden)
            ->setDiscontinued($discontinued)
            ->setForbidden($forbidden)
            ->setPreference($preference)
            ->setHuntstop($huntstop)
            ->setFormula($formula)
            ->setRoute_category($route_category)
            ->setOp_route_category($op_route_category)
            ->setOp_preference($op_preference)
            ->setOp_huntstop($op_huntstop)
            ->setI_rate_formula($i_rate_formula)
            ->setReverse_rating($reverse_rating)
            ->setSpecial_price_1($special_price_1)
            ->setSpecial_price_n($special_price_n)
            ->setI_dest_group($i_dest_group)
            ->setDestination_group($destination_group)
            ->setDescription($description)
            ->setEditable($editable)
            ->setCountry($country);
    }
    /**
     * Get i_tariff value
     * @return int
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\RateInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get interval_1 value
     * @return int
     */
    public function getInterval_1()
    {
        return $this->interval_1;
    }
    /**
     * Set interval_1 value
     * @param int $interval_1
     * @return \StructType\RateInfo
     */
    public function setInterval_1($interval_1 = null)
    {
        // validation for constraint: int
        if (!is_null($interval_1) && !is_numeric($interval_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interval_1)), __LINE__);
        }
        $this->interval_1 = $interval_1;
        return $this;
    }
    /**
     * Get interval_n value
     * @return int
     */
    public function getInterval_n()
    {
        return $this->interval_n;
    }
    /**
     * Set interval_n value
     * @param int $interval_n
     * @return \StructType\RateInfo
     */
    public function setInterval_n($interval_n = null)
    {
        // validation for constraint: int
        if (!is_null($interval_n) && !is_numeric($interval_n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interval_n)), __LINE__);
        }
        $this->interval_n = $interval_n;
        return $this;
    }
    /**
     * Get price_1 value
     * @return float
     */
    public function getPrice_1()
    {
        return $this->price_1;
    }
    /**
     * Set price_1 value
     * @param float $price_1
     * @return \StructType\RateInfo
     */
    public function setPrice_1($price_1 = null)
    {
        $this->price_1 = $price_1;
        return $this;
    }
    /**
     * Get price_n value
     * @return float
     */
    public function getPrice_n()
    {
        return $this->price_n;
    }
    /**
     * Set price_n value
     * @param float $price_n
     * @return \StructType\RateInfo
     */
    public function setPrice_n($price_n = null)
    {
        $this->price_n = $price_n;
        return $this;
    }
    /**
     * Get op_interval_1 value
     * @return int
     */
    public function getOp_interval_1()
    {
        return $this->op_interval_1;
    }
    /**
     * Set op_interval_1 value
     * @param int $op_interval_1
     * @return \StructType\RateInfo
     */
    public function setOp_interval_1($op_interval_1 = null)
    {
        // validation for constraint: int
        if (!is_null($op_interval_1) && !is_numeric($op_interval_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($op_interval_1)), __LINE__);
        }
        $this->op_interval_1 = $op_interval_1;
        return $this;
    }
    /**
     * Get op_interval_n value
     * @return int
     */
    public function getOp_interval_n()
    {
        return $this->op_interval_n;
    }
    /**
     * Set op_interval_n value
     * @param int $op_interval_n
     * @return \StructType\RateInfo
     */
    public function setOp_interval_n($op_interval_n = null)
    {
        // validation for constraint: int
        if (!is_null($op_interval_n) && !is_numeric($op_interval_n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($op_interval_n)), __LINE__);
        }
        $this->op_interval_n = $op_interval_n;
        return $this;
    }
    /**
     * Get op_price_1 value
     * @return float
     */
    public function getOp_price_1()
    {
        return $this->op_price_1;
    }
    /**
     * Set op_price_1 value
     * @param float $op_price_1
     * @return \StructType\RateInfo
     */
    public function setOp_price_1($op_price_1 = null)
    {
        $this->op_price_1 = $op_price_1;
        return $this;
    }
    /**
     * Get op_price_n value
     * @return float
     */
    public function getOp_price_n()
    {
        return $this->op_price_n;
    }
    /**
     * Set op_price_n value
     * @param float $op_price_n
     * @return \StructType\RateInfo
     */
    public function setOp_price_n($op_price_n = null)
    {
        $this->op_price_n = $op_price_n;
        return $this;
    }
    /**
     * Get i_dest value
     * @return int|null
     */
    public function getI_dest()
    {
        return $this->i_dest;
    }
    /**
     * Set i_dest value
     * @param int $i_dest
     * @return \StructType\RateInfo
     */
    public function setI_dest($i_dest = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest) && !is_numeric($i_dest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest)), __LINE__);
        }
        $this->i_dest = $i_dest;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\RateInfo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get i_rate value
     * @return int|null
     */
    public function getI_rate()
    {
        return $this->i_rate;
    }
    /**
     * Set i_rate value
     * @param int $i_rate
     * @return \StructType\RateInfo
     */
    public function setI_rate($i_rate = null)
    {
        // validation for constraint: int
        if (!is_null($i_rate) && !is_numeric($i_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rate)), __LINE__);
        }
        $this->i_rate = $i_rate;
        return $this;
    }
    /**
     * Get i_offpeak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_offpeak()
    {
        return isset($this->i_offpeak) ? $this->i_offpeak : null;
    }
    /**
     * Set i_offpeak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_offpeak
     * @return \StructType\RateInfo
     */
    public function setI_offpeak($i_offpeak = null)
    {
        // validation for constraint: int
        if (!is_null($i_offpeak) && !is_numeric($i_offpeak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_offpeak)), __LINE__);
        }
        if (is_null($i_offpeak) || (is_array($i_offpeak) && empty($i_offpeak))) {
            unset($this->i_offpeak);
        } else {
            $this->i_offpeak = $i_offpeak;
        }
        return $this;
    }
    /**
     * Get effective_from value
     * @return string|null
     */
    public function getEffective_from()
    {
        return $this->effective_from;
    }
    /**
     * Set effective_from value
     * @param string $effective_from
     * @return \StructType\RateInfo
     */
    public function setEffective_from($effective_from = null)
    {
        // validation for constraint: string
        if (!is_null($effective_from) && !is_string($effective_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_from)), __LINE__);
        }
        $this->effective_from = $effective_from;
        return $this;
    }
    /**
     * Get inactive_from value
     * @return string|null
     */
    public function getInactive_from()
    {
        return $this->inactive_from;
    }
    /**
     * Set inactive_from value
     * @param string $inactive_from
     * @return \StructType\RateInfo
     */
    public function setInactive_from($inactive_from = null)
    {
        // validation for constraint: string
        if (!is_null($inactive_from) && !is_string($inactive_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inactive_from)), __LINE__);
        }
        $this->inactive_from = $inactive_from;
        return $this;
    }
    /**
     * Get effective_immediately value
     * @return string|null
     */
    public function getEffective_immediately()
    {
        return $this->effective_immediately;
    }
    /**
     * Set effective_immediately value
     * @param string $effective_immediately
     * @return \StructType\RateInfo
     */
    public function setEffective_immediately($effective_immediately = null)
    {
        // validation for constraint: string
        if (!is_null($effective_immediately) && !is_string($effective_immediately)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_immediately)), __LINE__);
        }
        $this->effective_immediately = $effective_immediately;
        return $this;
    }
    /**
     * Get effective_now value
     * @return string|null
     */
    public function getEffective_now()
    {
        return $this->effective_now;
    }
    /**
     * Set effective_now value
     * @param string $effective_now
     * @return \StructType\RateInfo
     */
    public function setEffective_now($effective_now = null)
    {
        // validation for constraint: string
        if (!is_null($effective_now) && !is_string($effective_now)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_now)), __LINE__);
        }
        $this->effective_now = $effective_now;
        return $this;
    }
    /**
     * Get hidden value
     * @return string|null
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    /**
     * Set hidden value
     * @param string $hidden
     * @return \StructType\RateInfo
     */
    public function setHidden($hidden = null)
    {
        // validation for constraint: string
        if (!is_null($hidden) && !is_string($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hidden)), __LINE__);
        }
        $this->hidden = $hidden;
        return $this;
    }
    /**
     * Get discontinued value
     * @return string|null
     */
    public function getDiscontinued()
    {
        return $this->discontinued;
    }
    /**
     * Set discontinued value
     * @param string $discontinued
     * @return \StructType\RateInfo
     */
    public function setDiscontinued($discontinued = null)
    {
        // validation for constraint: string
        if (!is_null($discontinued) && !is_string($discontinued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discontinued)), __LINE__);
        }
        $this->discontinued = $discontinued;
        return $this;
    }
    /**
     * Get forbidden value
     * @return string|null
     */
    public function getForbidden()
    {
        return $this->forbidden;
    }
    /**
     * Set forbidden value
     * @param string $forbidden
     * @return \StructType\RateInfo
     */
    public function setForbidden($forbidden = null)
    {
        // validation for constraint: string
        if (!is_null($forbidden) && !is_string($forbidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forbidden)), __LINE__);
        }
        $this->forbidden = $forbidden;
        return $this;
    }
    /**
     * Get preference value
     * @return int|null
     */
    public function getPreference()
    {
        return $this->preference;
    }
    /**
     * Set preference value
     * @param int $preference
     * @return \StructType\RateInfo
     */
    public function setPreference($preference = null)
    {
        // validation for constraint: int
        if (!is_null($preference) && !is_numeric($preference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preference)), __LINE__);
        }
        $this->preference = $preference;
        return $this;
    }
    /**
     * Get huntstop value
     * @return string|null
     */
    public function getHuntstop()
    {
        return $this->huntstop;
    }
    /**
     * Set huntstop value
     * @param string $huntstop
     * @return \StructType\RateInfo
     */
    public function setHuntstop($huntstop = null)
    {
        // validation for constraint: string
        if (!is_null($huntstop) && !is_string($huntstop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huntstop)), __LINE__);
        }
        $this->huntstop = $huntstop;
        return $this;
    }
    /**
     * Get formula value
     * @return string|null
     */
    public function getFormula()
    {
        return $this->formula;
    }
    /**
     * Set formula value
     * @param string $formula
     * @return \StructType\RateInfo
     */
    public function setFormula($formula = null)
    {
        // validation for constraint: string
        if (!is_null($formula) && !is_string($formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formula)), __LINE__);
        }
        $this->formula = $formula;
        return $this;
    }
    /**
     * Get route_category value
     * @return int|null
     */
    public function getRoute_category()
    {
        return $this->route_category;
    }
    /**
     * Set route_category value
     * @param int $route_category
     * @return \StructType\RateInfo
     */
    public function setRoute_category($route_category = null)
    {
        // validation for constraint: int
        if (!is_null($route_category) && !is_numeric($route_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($route_category)), __LINE__);
        }
        $this->route_category = $route_category;
        return $this;
    }
    /**
     * Get op_route_category value
     * @return int|null
     */
    public function getOp_route_category()
    {
        return $this->op_route_category;
    }
    /**
     * Set op_route_category value
     * @param int $op_route_category
     * @return \StructType\RateInfo
     */
    public function setOp_route_category($op_route_category = null)
    {
        // validation for constraint: int
        if (!is_null($op_route_category) && !is_numeric($op_route_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($op_route_category)), __LINE__);
        }
        $this->op_route_category = $op_route_category;
        return $this;
    }
    /**
     * Get op_preference value
     * @return int|null
     */
    public function getOp_preference()
    {
        return $this->op_preference;
    }
    /**
     * Set op_preference value
     * @param int $op_preference
     * @return \StructType\RateInfo
     */
    public function setOp_preference($op_preference = null)
    {
        // validation for constraint: int
        if (!is_null($op_preference) && !is_numeric($op_preference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($op_preference)), __LINE__);
        }
        $this->op_preference = $op_preference;
        return $this;
    }
    /**
     * Get op_huntstop value
     * @return string|null
     */
    public function getOp_huntstop()
    {
        return $this->op_huntstop;
    }
    /**
     * Set op_huntstop value
     * @param string $op_huntstop
     * @return \StructType\RateInfo
     */
    public function setOp_huntstop($op_huntstop = null)
    {
        // validation for constraint: string
        if (!is_null($op_huntstop) && !is_string($op_huntstop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($op_huntstop)), __LINE__);
        }
        $this->op_huntstop = $op_huntstop;
        return $this;
    }
    /**
     * Get i_rate_formula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_rate_formula()
    {
        return isset($this->i_rate_formula) ? $this->i_rate_formula : null;
    }
    /**
     * Set i_rate_formula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_rate_formula
     * @return \StructType\RateInfo
     */
    public function setI_rate_formula($i_rate_formula = null)
    {
        // validation for constraint: int
        if (!is_null($i_rate_formula) && !is_numeric($i_rate_formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rate_formula)), __LINE__);
        }
        if (is_null($i_rate_formula) || (is_array($i_rate_formula) && empty($i_rate_formula))) {
            unset($this->i_rate_formula);
        } else {
            $this->i_rate_formula = $i_rate_formula;
        }
        return $this;
    }
    /**
     * Get reverse_rating value
     * @return string|null
     */
    public function getReverse_rating()
    {
        return $this->reverse_rating;
    }
    /**
     * Set reverse_rating value
     * @param string $reverse_rating
     * @return \StructType\RateInfo
     */
    public function setReverse_rating($reverse_rating = null)
    {
        // validation for constraint: string
        if (!is_null($reverse_rating) && !is_string($reverse_rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reverse_rating)), __LINE__);
        }
        $this->reverse_rating = $reverse_rating;
        return $this;
    }
    /**
     * Get special_price_1 value
     * @return float|null
     */
    public function getSpecial_price_1()
    {
        return $this->special_price_1;
    }
    /**
     * Set special_price_1 value
     * @param float $special_price_1
     * @return \StructType\RateInfo
     */
    public function setSpecial_price_1($special_price_1 = null)
    {
        $this->special_price_1 = $special_price_1;
        return $this;
    }
    /**
     * Get special_price_n value
     * @return float|null
     */
    public function getSpecial_price_n()
    {
        return $this->special_price_n;
    }
    /**
     * Set special_price_n value
     * @param float $special_price_n
     * @return \StructType\RateInfo
     */
    public function setSpecial_price_n($special_price_n = null)
    {
        $this->special_price_n = $special_price_n;
        return $this;
    }
    /**
     * Get i_dest_group value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_dest_group()
    {
        return isset($this->i_dest_group) ? $this->i_dest_group : null;
    }
    /**
     * Set i_dest_group value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_dest_group
     * @return \StructType\RateInfo
     */
    public function setI_dest_group($i_dest_group = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group) && !is_numeric($i_dest_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group)), __LINE__);
        }
        if (is_null($i_dest_group) || (is_array($i_dest_group) && empty($i_dest_group))) {
            unset($this->i_dest_group);
        } else {
            $this->i_dest_group = $i_dest_group;
        }
        return $this;
    }
    /**
     * Get destination_group value
     * @return string|null
     */
    public function getDestination_group()
    {
        return $this->destination_group;
    }
    /**
     * Set destination_group value
     * @param string $destination_group
     * @return \StructType\RateInfo
     */
    public function setDestination_group($destination_group = null)
    {
        // validation for constraint: string
        if (!is_null($destination_group) && !is_string($destination_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination_group)), __LINE__);
        }
        $this->destination_group = $destination_group;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RateInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get editable value
     * @return string|null
     */
    public function getEditable()
    {
        return $this->editable;
    }
    /**
     * Set editable value
     * @param string $editable
     * @return \StructType\RateInfo
     */
    public function setEditable($editable = null)
    {
        // validation for constraint: string
        if (!is_null($editable) && !is_string($editable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($editable)), __LINE__);
        }
        $this->editable = $editable;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\RateInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
