<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSystemInfo StructType
 * @subpackage Structs
 */
class PaymentSystemInfo extends AbstractStructBase
{
    /**
     * The payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $payment_method;
    /**
     * The i_payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_payment_method;
    /**
     * The min_allowed_payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $min_allowed_payment;
    /**
     * The ext_auth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ext_auth;
    /**
     * The processor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $processor;
    /**
     * The merchant_account_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $merchant_account_name;
    /**
     * The i_online_payment_processor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_online_payment_processor;
    /**
     * The web_link
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $web_link;
    /**
     * The handler
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $handler;
    /**
     * The callback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callback;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The url_suffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url_suffix;
    /**
     * The icon_url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $icon_url;
    /**
     * The refnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refnum;
    /**
     * The test_mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $test_mode;
    /**
     * The recurring
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recurring;
    /**
     * Constructor method for PaymentSystemInfo
     * @uses PaymentSystemInfo::setPayment_method()
     * @uses PaymentSystemInfo::setI_payment_method()
     * @uses PaymentSystemInfo::setMin_allowed_payment()
     * @uses PaymentSystemInfo::setExt_auth()
     * @uses PaymentSystemInfo::setProcessor()
     * @uses PaymentSystemInfo::setMerchant_account_name()
     * @uses PaymentSystemInfo::setI_online_payment_processor()
     * @uses PaymentSystemInfo::setWeb_link()
     * @uses PaymentSystemInfo::setHandler()
     * @uses PaymentSystemInfo::setCallback()
     * @uses PaymentSystemInfo::setLogin()
     * @uses PaymentSystemInfo::setUrl_suffix()
     * @uses PaymentSystemInfo::setIcon_url()
     * @uses PaymentSystemInfo::setRefnum()
     * @uses PaymentSystemInfo::setTest_mode()
     * @uses PaymentSystemInfo::setRecurring()
     * @param string $payment_method
     * @param int $i_payment_method
     * @param float $min_allowed_payment
     * @param string $ext_auth
     * @param string $processor
     * @param string $merchant_account_name
     * @param int $i_online_payment_processor
     * @param string $web_link
     * @param string $handler
     * @param string $callback
     * @param string $login
     * @param string $url_suffix
     * @param string $icon_url
     * @param string $refnum
     * @param string $test_mode
     * @param string $recurring
     */
    public function __construct($payment_method = null, $i_payment_method = null, $min_allowed_payment = null, $ext_auth = null, $processor = null, $merchant_account_name = null, $i_online_payment_processor = null, $web_link = null, $handler = null, $callback = null, $login = null, $url_suffix = null, $icon_url = null, $refnum = null, $test_mode = null, $recurring = null)
    {
        $this
            ->setPayment_method($payment_method)
            ->setI_payment_method($i_payment_method)
            ->setMin_allowed_payment($min_allowed_payment)
            ->setExt_auth($ext_auth)
            ->setProcessor($processor)
            ->setMerchant_account_name($merchant_account_name)
            ->setI_online_payment_processor($i_online_payment_processor)
            ->setWeb_link($web_link)
            ->setHandler($handler)
            ->setCallback($callback)
            ->setLogin($login)
            ->setUrl_suffix($url_suffix)
            ->setIcon_url($icon_url)
            ->setRefnum($refnum)
            ->setTest_mode($test_mode)
            ->setRecurring($recurring);
    }
    /**
     * Get payment_method value
     * @return string
     */
    public function getPayment_method()
    {
        return $this->payment_method;
    }
    /**
     * Set payment_method value
     * @param string $payment_method
     * @return \StructType\PaymentSystemInfo
     */
    public function setPayment_method($payment_method = null)
    {
        // validation for constraint: string
        if (!is_null($payment_method) && !is_string($payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_method)), __LINE__);
        }
        $this->payment_method = $payment_method;
        return $this;
    }
    /**
     * Get i_payment_method value
     * @return int
     */
    public function getI_payment_method()
    {
        return $this->i_payment_method;
    }
    /**
     * Set i_payment_method value
     * @param int $i_payment_method
     * @return \StructType\PaymentSystemInfo
     */
    public function setI_payment_method($i_payment_method = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_method) && !is_numeric($i_payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_method)), __LINE__);
        }
        $this->i_payment_method = $i_payment_method;
        return $this;
    }
    /**
     * Get min_allowed_payment value
     * @return float|null
     */
    public function getMin_allowed_payment()
    {
        return $this->min_allowed_payment;
    }
    /**
     * Set min_allowed_payment value
     * @param float $min_allowed_payment
     * @return \StructType\PaymentSystemInfo
     */
    public function setMin_allowed_payment($min_allowed_payment = null)
    {
        $this->min_allowed_payment = $min_allowed_payment;
        return $this;
    }
    /**
     * Get ext_auth value
     * @return string|null
     */
    public function getExt_auth()
    {
        return $this->ext_auth;
    }
    /**
     * Set ext_auth value
     * @param string $ext_auth
     * @return \StructType\PaymentSystemInfo
     */
    public function setExt_auth($ext_auth = null)
    {
        // validation for constraint: string
        if (!is_null($ext_auth) && !is_string($ext_auth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ext_auth)), __LINE__);
        }
        $this->ext_auth = $ext_auth;
        return $this;
    }
    /**
     * Get processor value
     * @return string|null
     */
    public function getProcessor()
    {
        return $this->processor;
    }
    /**
     * Set processor value
     * @param string $processor
     * @return \StructType\PaymentSystemInfo
     */
    public function setProcessor($processor = null)
    {
        // validation for constraint: string
        if (!is_null($processor) && !is_string($processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processor)), __LINE__);
        }
        $this->processor = $processor;
        return $this;
    }
    /**
     * Get merchant_account_name value
     * @return string|null
     */
    public function getMerchant_account_name()
    {
        return $this->merchant_account_name;
    }
    /**
     * Set merchant_account_name value
     * @param string $merchant_account_name
     * @return \StructType\PaymentSystemInfo
     */
    public function setMerchant_account_name($merchant_account_name = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_account_name) && !is_string($merchant_account_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchant_account_name)), __LINE__);
        }
        $this->merchant_account_name = $merchant_account_name;
        return $this;
    }
    /**
     * Get i_online_payment_processor value
     * @return int|null
     */
    public function getI_online_payment_processor()
    {
        return $this->i_online_payment_processor;
    }
    /**
     * Set i_online_payment_processor value
     * @param int $i_online_payment_processor
     * @return \StructType\PaymentSystemInfo
     */
    public function setI_online_payment_processor($i_online_payment_processor = null)
    {
        // validation for constraint: int
        if (!is_null($i_online_payment_processor) && !is_numeric($i_online_payment_processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_online_payment_processor)), __LINE__);
        }
        $this->i_online_payment_processor = $i_online_payment_processor;
        return $this;
    }
    /**
     * Get web_link value
     * @return string|null
     */
    public function getWeb_link()
    {
        return $this->web_link;
    }
    /**
     * Set web_link value
     * @param string $web_link
     * @return \StructType\PaymentSystemInfo
     */
    public function setWeb_link($web_link = null)
    {
        // validation for constraint: string
        if (!is_null($web_link) && !is_string($web_link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($web_link)), __LINE__);
        }
        $this->web_link = $web_link;
        return $this;
    }
    /**
     * Get handler value
     * @return string|null
     */
    public function getHandler()
    {
        return $this->handler;
    }
    /**
     * Set handler value
     * @param string $handler
     * @return \StructType\PaymentSystemInfo
     */
    public function setHandler($handler = null)
    {
        // validation for constraint: string
        if (!is_null($handler) && !is_string($handler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handler)), __LINE__);
        }
        $this->handler = $handler;
        return $this;
    }
    /**
     * Get callback value
     * @return string|null
     */
    public function getCallback()
    {
        return $this->callback;
    }
    /**
     * Set callback value
     * @param string $callback
     * @return \StructType\PaymentSystemInfo
     */
    public function setCallback($callback = null)
    {
        // validation for constraint: string
        if (!is_null($callback) && !is_string($callback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callback)), __LINE__);
        }
        $this->callback = $callback;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\PaymentSystemInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get url_suffix value
     * @return string|null
     */
    public function getUrl_suffix()
    {
        return $this->url_suffix;
    }
    /**
     * Set url_suffix value
     * @param string $url_suffix
     * @return \StructType\PaymentSystemInfo
     */
    public function setUrl_suffix($url_suffix = null)
    {
        // validation for constraint: string
        if (!is_null($url_suffix) && !is_string($url_suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url_suffix)), __LINE__);
        }
        $this->url_suffix = $url_suffix;
        return $this;
    }
    /**
     * Get icon_url value
     * @return string|null
     */
    public function getIcon_url()
    {
        return $this->icon_url;
    }
    /**
     * Set icon_url value
     * @param string $icon_url
     * @return \StructType\PaymentSystemInfo
     */
    public function setIcon_url($icon_url = null)
    {
        // validation for constraint: string
        if (!is_null($icon_url) && !is_string($icon_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icon_url)), __LINE__);
        }
        $this->icon_url = $icon_url;
        return $this;
    }
    /**
     * Get refnum value
     * @return string|null
     */
    public function getRefnum()
    {
        return $this->refnum;
    }
    /**
     * Set refnum value
     * @param string $refnum
     * @return \StructType\PaymentSystemInfo
     */
    public function setRefnum($refnum = null)
    {
        // validation for constraint: string
        if (!is_null($refnum) && !is_string($refnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refnum)), __LINE__);
        }
        $this->refnum = $refnum;
        return $this;
    }
    /**
     * Get test_mode value
     * @return string|null
     */
    public function getTest_mode()
    {
        return $this->test_mode;
    }
    /**
     * Set test_mode value
     * @param string $test_mode
     * @return \StructType\PaymentSystemInfo
     */
    public function setTest_mode($test_mode = null)
    {
        // validation for constraint: string
        if (!is_null($test_mode) && !is_string($test_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($test_mode)), __LINE__);
        }
        $this->test_mode = $test_mode;
        return $this;
    }
    /**
     * Get recurring value
     * @return string|null
     */
    public function getRecurring()
    {
        return $this->recurring;
    }
    /**
     * Set recurring value
     * @param string $recurring
     * @return \StructType\PaymentSystemInfo
     */
    public function setRecurring($recurring = null)
    {
        // validation for constraint: string
        if (!is_null($recurring) && !is_string($recurring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurring)), __LINE__);
        }
        $this->recurring = $recurring;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentSystemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
