<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutOfTurnXDRInfo StructType
 * @subpackage Structs
 */
class OutOfTurnXDRInfo extends AbstractStructBase
{
    /**
     * The i_xdr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_xdr;
    /**
     * The owner_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $owner_type;
    /**
     * Constructor method for OutOfTurnXDRInfo
     * @uses OutOfTurnXDRInfo::setI_xdr()
     * @uses OutOfTurnXDRInfo::setOwner_type()
     * @param int $i_xdr
     * @param string $owner_type
     */
    public function __construct($i_xdr = null, $owner_type = null)
    {
        $this
            ->setI_xdr($i_xdr)
            ->setOwner_type($owner_type);
    }
    /**
     * Get i_xdr value
     * @return int
     */
    public function getI_xdr()
    {
        return $this->i_xdr;
    }
    /**
     * Set i_xdr value
     * @param int $i_xdr
     * @return \StructType\OutOfTurnXDRInfo
     */
    public function setI_xdr($i_xdr = null)
    {
        // validation for constraint: int
        if (!is_null($i_xdr) && !is_numeric($i_xdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_xdr)), __LINE__);
        }
        $this->i_xdr = $i_xdr;
        return $this;
    }
    /**
     * Get owner_type value
     * @return string
     */
    public function getOwner_type()
    {
        return $this->owner_type;
    }
    /**
     * Set owner_type value
     * @param string $owner_type
     * @return \StructType\OutOfTurnXDRInfo
     */
    public function setOwner_type($owner_type = null)
    {
        // validation for constraint: string
        if (!is_null($owner_type) && !is_string($owner_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner_type)), __LINE__);
        }
        $this->owner_type = $owner_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutOfTurnXDRInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
