<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveAccountRequest StructType
 * @subpackage Structs
 */
class MoveAccountRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The batch_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $batch_name;
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_product;
    /**
     * The i_vd_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_vd_plan;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_routing_plan;
    /**
     * Constructor method for MoveAccountRequest
     * @uses MoveAccountRequest::setI_account()
     * @uses MoveAccountRequest::setI_customer()
     * @uses MoveAccountRequest::setBatch_name()
     * @uses MoveAccountRequest::setI_product()
     * @uses MoveAccountRequest::setI_vd_plan()
     * @uses MoveAccountRequest::setI_routing_plan()
     * @param int $i_account
     * @param int $i_customer
     * @param string $batch_name
     * @param int $i_product
     * @param int $i_vd_plan
     * @param int $i_routing_plan
     */
    public function __construct($i_account = null, $i_customer = null, $batch_name = null, $i_product = null, $i_vd_plan = null, $i_routing_plan = null)
    {
        $this
            ->setI_account($i_account)
            ->setI_customer($i_customer)
            ->setBatch_name($batch_name)
            ->setI_product($i_product)
            ->setI_vd_plan($i_vd_plan)
            ->setI_routing_plan($i_routing_plan);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\MoveAccountRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\MoveAccountRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get batch_name value
     * @return string
     */
    public function getBatch_name()
    {
        return $this->batch_name;
    }
    /**
     * Set batch_name value
     * @param string $batch_name
     * @return \StructType\MoveAccountRequest
     */
    public function setBatch_name($batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($batch_name) && !is_string($batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batch_name)), __LINE__);
        }
        $this->batch_name = $batch_name;
        return $this;
    }
    /**
     * Get i_product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_product()
    {
        return isset($this->i_product) ? $this->i_product : null;
    }
    /**
     * Set i_product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_product
     * @return \StructType\MoveAccountRequest
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        if (is_null($i_product) || (is_array($i_product) && empty($i_product))) {
            unset($this->i_product);
        } else {
            $this->i_product = $i_product;
        }
        return $this;
    }
    /**
     * Get i_vd_plan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_vd_plan()
    {
        return isset($this->i_vd_plan) ? $this->i_vd_plan : null;
    }
    /**
     * Set i_vd_plan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_vd_plan
     * @return \StructType\MoveAccountRequest
     */
    public function setI_vd_plan($i_vd_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_plan) && !is_numeric($i_vd_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_plan)), __LINE__);
        }
        if (is_null($i_vd_plan) || (is_array($i_vd_plan) && empty($i_vd_plan))) {
            unset($this->i_vd_plan);
        } else {
            $this->i_vd_plan = $i_vd_plan;
        }
        return $this;
    }
    /**
     * Get i_routing_plan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return isset($this->i_routing_plan) ? $this->i_routing_plan : null;
    }
    /**
     * Set i_routing_plan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_routing_plan
     * @return \StructType\MoveAccountRequest
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        if (is_null($i_routing_plan) || (is_array($i_routing_plan) && empty($i_routing_plan))) {
            unset($this->i_routing_plan);
        } else {
            $this->i_routing_plan = $i_routing_plan;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
