<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeTransferResponse StructType
 * @subpackage Structs
 */
class MakeTransferResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The error_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $error_description;
    /**
     * The transaction_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $transaction_id;
    /**
     * Constructor method for MakeTransferResponse
     * @uses MakeTransferResponse::setError_code()
     * @uses MakeTransferResponse::setError_description()
     * @uses MakeTransferResponse::setTransaction_id()
     * @param int $error_code
     * @param string $error_description
     * @param int $transaction_id
     */
    public function __construct($error_code = null, $error_description = null, $transaction_id = null)
    {
        $this
            ->setError_code($error_code)
            ->setError_description($error_description)
            ->setTransaction_id($transaction_id);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\MakeTransferResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !is_numeric($error_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get error_description value
     * @return string
     */
    public function getError_description()
    {
        return $this->error_description;
    }
    /**
     * Set error_description value
     * @param string $error_description
     * @return \StructType\MakeTransferResponse
     */
    public function setError_description($error_description = null)
    {
        // validation for constraint: string
        if (!is_null($error_description) && !is_string($error_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error_description)), __LINE__);
        }
        $this->error_description = $error_description;
        return $this;
    }
    /**
     * Get transaction_id value
     * @return int|null
     */
    public function getTransaction_id()
    {
        return $this->transaction_id;
    }
    /**
     * Set transaction_id value
     * @param int $transaction_id
     * @return \StructType\MakeTransferResponse
     */
    public function setTransaction_id($transaction_id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_id) && !is_numeric($transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_id)), __LINE__);
        }
        $this->transaction_id = $transaction_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeTransferResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
