<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The i_invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_invoice;
    /**
     * The invoice_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $invoice_number;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The issue_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issue_date;
    /**
     * The period_from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $period_from;
    /**
     * The period_to
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $period_to;
    /**
     * The amount_net
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount_net;
    /**
     * The amount_due
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount_due;
    /**
     * The closed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $closed;
    /**
     * The previous_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $previous_balance;
    /**
     * The payments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $payments;
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subscriptions;
    /**
     * The manual_charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $manual_charges;
    /**
     * The taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxes;
    /**
     * The calls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $calls;
    /**
     * The new_style
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $new_style;
    /**
     * The due_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $due_date;
    /**
     * The i_invoice_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_invoice_status;
    /**
     * The amount_paid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount_paid;
    /**
     * The last_notific_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_notific_date;
    /**
     * The last_resend_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_resend_date;
    /**
     * The last_recollect_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_recollect_date;
    /**
     * The last_warning_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_warning_date;
    /**
     * The last_suspension_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_suspension_date;
    /**
     * The last_closing_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_closing_date;
    /**
     * The tax_method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tax_method;
    /**
     * The i_billing_processor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_billing_processor;
    /**
     * The prior_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $prior_balance;
    /**
     * The prior_balance_paid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $prior_balance_paid;
    /**
     * The is_void
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_void;
    /**
     * The customer_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_name;
    /**
     * The invoice_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoice_status;
    /**
     * The i_parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_parent;
    /**
     * Constructor method for InvoiceInfo
     * @uses InvoiceInfo::setI_invoice()
     * @uses InvoiceInfo::setInvoice_number()
     * @uses InvoiceInfo::setI_customer()
     * @uses InvoiceInfo::setIssue_date()
     * @uses InvoiceInfo::setPeriod_from()
     * @uses InvoiceInfo::setPeriod_to()
     * @uses InvoiceInfo::setAmount_net()
     * @uses InvoiceInfo::setAmount_due()
     * @uses InvoiceInfo::setClosed()
     * @uses InvoiceInfo::setPrevious_balance()
     * @uses InvoiceInfo::setPayments()
     * @uses InvoiceInfo::setSubscriptions()
     * @uses InvoiceInfo::setManual_charges()
     * @uses InvoiceInfo::setTaxes()
     * @uses InvoiceInfo::setCalls()
     * @uses InvoiceInfo::setNew_style()
     * @uses InvoiceInfo::setDue_date()
     * @uses InvoiceInfo::setI_invoice_status()
     * @uses InvoiceInfo::setAmount_paid()
     * @uses InvoiceInfo::setLast_notific_date()
     * @uses InvoiceInfo::setLast_resend_date()
     * @uses InvoiceInfo::setLast_recollect_date()
     * @uses InvoiceInfo::setLast_warning_date()
     * @uses InvoiceInfo::setLast_suspension_date()
     * @uses InvoiceInfo::setLast_closing_date()
     * @uses InvoiceInfo::setTax_method()
     * @uses InvoiceInfo::setI_billing_processor()
     * @uses InvoiceInfo::setPrior_balance()
     * @uses InvoiceInfo::setPrior_balance_paid()
     * @uses InvoiceInfo::setIs_void()
     * @uses InvoiceInfo::setCustomer_name()
     * @uses InvoiceInfo::setInvoice_status()
     * @uses InvoiceInfo::setI_parent()
     * @param int $i_invoice
     * @param int $invoice_number
     * @param int $i_customer
     * @param string $issue_date
     * @param string $period_from
     * @param string $period_to
     * @param float $amount_net
     * @param float $amount_due
     * @param string $closed
     * @param float $previous_balance
     * @param float $payments
     * @param float $subscriptions
     * @param float $manual_charges
     * @param float $taxes
     * @param float $calls
     * @param int $new_style
     * @param string $due_date
     * @param int $i_invoice_status
     * @param float $amount_paid
     * @param string $last_notific_date
     * @param string $last_resend_date
     * @param string $last_recollect_date
     * @param string $last_warning_date
     * @param string $last_suspension_date
     * @param string $last_closing_date
     * @param int $tax_method
     * @param int $i_billing_processor
     * @param float $prior_balance
     * @param float $prior_balance_paid
     * @param string $is_void
     * @param string $customer_name
     * @param string $invoice_status
     * @param int $i_parent
     */
    public function __construct($i_invoice = null, $invoice_number = null, $i_customer = null, $issue_date = null, $period_from = null, $period_to = null, $amount_net = null, $amount_due = null, $closed = null, $previous_balance = null, $payments = null, $subscriptions = null, $manual_charges = null, $taxes = null, $calls = null, $new_style = null, $due_date = null, $i_invoice_status = null, $amount_paid = null, $last_notific_date = null, $last_resend_date = null, $last_recollect_date = null, $last_warning_date = null, $last_suspension_date = null, $last_closing_date = null, $tax_method = null, $i_billing_processor = null, $prior_balance = null, $prior_balance_paid = null, $is_void = null, $customer_name = null, $invoice_status = null, $i_parent = null)
    {
        $this
            ->setI_invoice($i_invoice)
            ->setInvoice_number($invoice_number)
            ->setI_customer($i_customer)
            ->setIssue_date($issue_date)
            ->setPeriod_from($period_from)
            ->setPeriod_to($period_to)
            ->setAmount_net($amount_net)
            ->setAmount_due($amount_due)
            ->setClosed($closed)
            ->setPrevious_balance($previous_balance)
            ->setPayments($payments)
            ->setSubscriptions($subscriptions)
            ->setManual_charges($manual_charges)
            ->setTaxes($taxes)
            ->setCalls($calls)
            ->setNew_style($new_style)
            ->setDue_date($due_date)
            ->setI_invoice_status($i_invoice_status)
            ->setAmount_paid($amount_paid)
            ->setLast_notific_date($last_notific_date)
            ->setLast_resend_date($last_resend_date)
            ->setLast_recollect_date($last_recollect_date)
            ->setLast_warning_date($last_warning_date)
            ->setLast_suspension_date($last_suspension_date)
            ->setLast_closing_date($last_closing_date)
            ->setTax_method($tax_method)
            ->setI_billing_processor($i_billing_processor)
            ->setPrior_balance($prior_balance)
            ->setPrior_balance_paid($prior_balance_paid)
            ->setIs_void($is_void)
            ->setCustomer_name($customer_name)
            ->setInvoice_status($invoice_status)
            ->setI_parent($i_parent);
    }
    /**
     * Get i_invoice value
     * @return int|null
     */
    public function getI_invoice()
    {
        return $this->i_invoice;
    }
    /**
     * Set i_invoice value
     * @param int $i_invoice
     * @return \StructType\InvoiceInfo
     */
    public function setI_invoice($i_invoice = null)
    {
        // validation for constraint: int
        if (!is_null($i_invoice) && !is_numeric($i_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_invoice)), __LINE__);
        }
        $this->i_invoice = $i_invoice;
        return $this;
    }
    /**
     * Get invoice_number value
     * @return int|null
     */
    public function getInvoice_number()
    {
        return $this->invoice_number;
    }
    /**
     * Set invoice_number value
     * @param int $invoice_number
     * @return \StructType\InvoiceInfo
     */
    public function setInvoice_number($invoice_number = null)
    {
        // validation for constraint: int
        if (!is_null($invoice_number) && !is_numeric($invoice_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoice_number)), __LINE__);
        }
        $this->invoice_number = $invoice_number;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\InvoiceInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get issue_date value
     * @return string|null
     */
    public function getIssue_date()
    {
        return $this->issue_date;
    }
    /**
     * Set issue_date value
     * @param string $issue_date
     * @return \StructType\InvoiceInfo
     */
    public function setIssue_date($issue_date = null)
    {
        // validation for constraint: string
        if (!is_null($issue_date) && !is_string($issue_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issue_date)), __LINE__);
        }
        $this->issue_date = $issue_date;
        return $this;
    }
    /**
     * Get period_from value
     * @return string|null
     */
    public function getPeriod_from()
    {
        return $this->period_from;
    }
    /**
     * Set period_from value
     * @param string $period_from
     * @return \StructType\InvoiceInfo
     */
    public function setPeriod_from($period_from = null)
    {
        // validation for constraint: string
        if (!is_null($period_from) && !is_string($period_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period_from)), __LINE__);
        }
        $this->period_from = $period_from;
        return $this;
    }
    /**
     * Get period_to value
     * @return string|null
     */
    public function getPeriod_to()
    {
        return $this->period_to;
    }
    /**
     * Set period_to value
     * @param string $period_to
     * @return \StructType\InvoiceInfo
     */
    public function setPeriod_to($period_to = null)
    {
        // validation for constraint: string
        if (!is_null($period_to) && !is_string($period_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period_to)), __LINE__);
        }
        $this->period_to = $period_to;
        return $this;
    }
    /**
     * Get amount_net value
     * @return float|null
     */
    public function getAmount_net()
    {
        return $this->amount_net;
    }
    /**
     * Set amount_net value
     * @param float $amount_net
     * @return \StructType\InvoiceInfo
     */
    public function setAmount_net($amount_net = null)
    {
        $this->amount_net = $amount_net;
        return $this;
    }
    /**
     * Get amount_due value
     * @return float|null
     */
    public function getAmount_due()
    {
        return $this->amount_due;
    }
    /**
     * Set amount_due value
     * @param float $amount_due
     * @return \StructType\InvoiceInfo
     */
    public function setAmount_due($amount_due = null)
    {
        $this->amount_due = $amount_due;
        return $this;
    }
    /**
     * Get closed value
     * @return string|null
     */
    public function getClosed()
    {
        return $this->closed;
    }
    /**
     * Set closed value
     * @param string $closed
     * @return \StructType\InvoiceInfo
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: string
        if (!is_null($closed) && !is_string($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closed)), __LINE__);
        }
        $this->closed = $closed;
        return $this;
    }
    /**
     * Get previous_balance value
     * @return float|null
     */
    public function getPrevious_balance()
    {
        return $this->previous_balance;
    }
    /**
     * Set previous_balance value
     * @param float $previous_balance
     * @return \StructType\InvoiceInfo
     */
    public function setPrevious_balance($previous_balance = null)
    {
        $this->previous_balance = $previous_balance;
        return $this;
    }
    /**
     * Get payments value
     * @return float|null
     */
    public function getPayments()
    {
        return $this->payments;
    }
    /**
     * Set payments value
     * @param float $payments
     * @return \StructType\InvoiceInfo
     */
    public function setPayments($payments = null)
    {
        $this->payments = $payments;
        return $this;
    }
    /**
     * Get subscriptions value
     * @return float|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * Set subscriptions value
     * @param float $subscriptions
     * @return \StructType\InvoiceInfo
     */
    public function setSubscriptions($subscriptions = null)
    {
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Get manual_charges value
     * @return float|null
     */
    public function getManual_charges()
    {
        return $this->manual_charges;
    }
    /**
     * Set manual_charges value
     * @param float $manual_charges
     * @return \StructType\InvoiceInfo
     */
    public function setManual_charges($manual_charges = null)
    {
        $this->manual_charges = $manual_charges;
        return $this;
    }
    /**
     * Get taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->taxes;
    }
    /**
     * Set taxes value
     * @param float $taxes
     * @return \StructType\InvoiceInfo
     */
    public function setTaxes($taxes = null)
    {
        $this->taxes = $taxes;
        return $this;
    }
    /**
     * Get calls value
     * @return float|null
     */
    public function getCalls()
    {
        return $this->calls;
    }
    /**
     * Set calls value
     * @param float $calls
     * @return \StructType\InvoiceInfo
     */
    public function setCalls($calls = null)
    {
        $this->calls = $calls;
        return $this;
    }
    /**
     * Get new_style value
     * @return int|null
     */
    public function getNew_style()
    {
        return $this->new_style;
    }
    /**
     * Set new_style value
     * @param int $new_style
     * @return \StructType\InvoiceInfo
     */
    public function setNew_style($new_style = null)
    {
        // validation for constraint: int
        if (!is_null($new_style) && !is_numeric($new_style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($new_style)), __LINE__);
        }
        $this->new_style = $new_style;
        return $this;
    }
    /**
     * Get due_date value
     * @return string|null
     */
    public function getDue_date()
    {
        return $this->due_date;
    }
    /**
     * Set due_date value
     * @param string $due_date
     * @return \StructType\InvoiceInfo
     */
    public function setDue_date($due_date = null)
    {
        // validation for constraint: string
        if (!is_null($due_date) && !is_string($due_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($due_date)), __LINE__);
        }
        $this->due_date = $due_date;
        return $this;
    }
    /**
     * Get i_invoice_status value
     * @return int|null
     */
    public function getI_invoice_status()
    {
        return $this->i_invoice_status;
    }
    /**
     * Set i_invoice_status value
     * @param int $i_invoice_status
     * @return \StructType\InvoiceInfo
     */
    public function setI_invoice_status($i_invoice_status = null)
    {
        // validation for constraint: int
        if (!is_null($i_invoice_status) && !is_numeric($i_invoice_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_invoice_status)), __LINE__);
        }
        $this->i_invoice_status = $i_invoice_status;
        return $this;
    }
    /**
     * Get amount_paid value
     * @return float|null
     */
    public function getAmount_paid()
    {
        return $this->amount_paid;
    }
    /**
     * Set amount_paid value
     * @param float $amount_paid
     * @return \StructType\InvoiceInfo
     */
    public function setAmount_paid($amount_paid = null)
    {
        $this->amount_paid = $amount_paid;
        return $this;
    }
    /**
     * Get last_notific_date value
     * @return string|null
     */
    public function getLast_notific_date()
    {
        return $this->last_notific_date;
    }
    /**
     * Set last_notific_date value
     * @param string $last_notific_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_notific_date($last_notific_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_notific_date) && !is_string($last_notific_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_notific_date)), __LINE__);
        }
        $this->last_notific_date = $last_notific_date;
        return $this;
    }
    /**
     * Get last_resend_date value
     * @return string|null
     */
    public function getLast_resend_date()
    {
        return $this->last_resend_date;
    }
    /**
     * Set last_resend_date value
     * @param string $last_resend_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_resend_date($last_resend_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_resend_date) && !is_string($last_resend_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_resend_date)), __LINE__);
        }
        $this->last_resend_date = $last_resend_date;
        return $this;
    }
    /**
     * Get last_recollect_date value
     * @return string|null
     */
    public function getLast_recollect_date()
    {
        return $this->last_recollect_date;
    }
    /**
     * Set last_recollect_date value
     * @param string $last_recollect_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_recollect_date($last_recollect_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_recollect_date) && !is_string($last_recollect_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_recollect_date)), __LINE__);
        }
        $this->last_recollect_date = $last_recollect_date;
        return $this;
    }
    /**
     * Get last_warning_date value
     * @return string|null
     */
    public function getLast_warning_date()
    {
        return $this->last_warning_date;
    }
    /**
     * Set last_warning_date value
     * @param string $last_warning_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_warning_date($last_warning_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_warning_date) && !is_string($last_warning_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_warning_date)), __LINE__);
        }
        $this->last_warning_date = $last_warning_date;
        return $this;
    }
    /**
     * Get last_suspension_date value
     * @return string|null
     */
    public function getLast_suspension_date()
    {
        return $this->last_suspension_date;
    }
    /**
     * Set last_suspension_date value
     * @param string $last_suspension_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_suspension_date($last_suspension_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_suspension_date) && !is_string($last_suspension_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_suspension_date)), __LINE__);
        }
        $this->last_suspension_date = $last_suspension_date;
        return $this;
    }
    /**
     * Get last_closing_date value
     * @return string|null
     */
    public function getLast_closing_date()
    {
        return $this->last_closing_date;
    }
    /**
     * Set last_closing_date value
     * @param string $last_closing_date
     * @return \StructType\InvoiceInfo
     */
    public function setLast_closing_date($last_closing_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_closing_date) && !is_string($last_closing_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_closing_date)), __LINE__);
        }
        $this->last_closing_date = $last_closing_date;
        return $this;
    }
    /**
     * Get tax_method value
     * @return int|null
     */
    public function getTax_method()
    {
        return $this->tax_method;
    }
    /**
     * Set tax_method value
     * @param int $tax_method
     * @return \StructType\InvoiceInfo
     */
    public function setTax_method($tax_method = null)
    {
        // validation for constraint: int
        if (!is_null($tax_method) && !is_numeric($tax_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tax_method)), __LINE__);
        }
        $this->tax_method = $tax_method;
        return $this;
    }
    /**
     * Get i_billing_processor value
     * @return int|null
     */
    public function getI_billing_processor()
    {
        return $this->i_billing_processor;
    }
    /**
     * Set i_billing_processor value
     * @param int $i_billing_processor
     * @return \StructType\InvoiceInfo
     */
    public function setI_billing_processor($i_billing_processor = null)
    {
        // validation for constraint: int
        if (!is_null($i_billing_processor) && !is_numeric($i_billing_processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_billing_processor)), __LINE__);
        }
        $this->i_billing_processor = $i_billing_processor;
        return $this;
    }
    /**
     * Get prior_balance value
     * @return float|null
     */
    public function getPrior_balance()
    {
        return $this->prior_balance;
    }
    /**
     * Set prior_balance value
     * @param float $prior_balance
     * @return \StructType\InvoiceInfo
     */
    public function setPrior_balance($prior_balance = null)
    {
        $this->prior_balance = $prior_balance;
        return $this;
    }
    /**
     * Get prior_balance_paid value
     * @return float|null
     */
    public function getPrior_balance_paid()
    {
        return $this->prior_balance_paid;
    }
    /**
     * Set prior_balance_paid value
     * @param float $prior_balance_paid
     * @return \StructType\InvoiceInfo
     */
    public function setPrior_balance_paid($prior_balance_paid = null)
    {
        $this->prior_balance_paid = $prior_balance_paid;
        return $this;
    }
    /**
     * Get is_void value
     * @return string|null
     */
    public function getIs_void()
    {
        return $this->is_void;
    }
    /**
     * Set is_void value
     * @param string $is_void
     * @return \StructType\InvoiceInfo
     */
    public function setIs_void($is_void = null)
    {
        // validation for constraint: string
        if (!is_null($is_void) && !is_string($is_void)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_void)), __LINE__);
        }
        $this->is_void = $is_void;
        return $this;
    }
    /**
     * Get customer_name value
     * @return string|null
     */
    public function getCustomer_name()
    {
        return $this->customer_name;
    }
    /**
     * Set customer_name value
     * @param string $customer_name
     * @return \StructType\InvoiceInfo
     */
    public function setCustomer_name($customer_name = null)
    {
        // validation for constraint: string
        if (!is_null($customer_name) && !is_string($customer_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_name)), __LINE__);
        }
        $this->customer_name = $customer_name;
        return $this;
    }
    /**
     * Get invoice_status value
     * @return string|null
     */
    public function getInvoice_status()
    {
        return $this->invoice_status;
    }
    /**
     * Set invoice_status value
     * @param string $invoice_status
     * @return \StructType\InvoiceInfo
     */
    public function setInvoice_status($invoice_status = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_status) && !is_string($invoice_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_status)), __LINE__);
        }
        $this->invoice_status = $invoice_status;
        return $this;
    }
    /**
     * Get i_parent value
     * @return int|null
     */
    public function getI_parent()
    {
        return $this->i_parent;
    }
    /**
     * Set i_parent value
     * @param int $i_parent
     * @return \StructType\InvoiceInfo
     */
    public function setI_parent($i_parent = null)
    {
        // validation for constraint: int
        if (!is_null($i_parent) && !is_numeric($i_parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_parent)), __LINE__);
        }
        $this->i_parent = $i_parent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
