<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUAListResponse StructType
 * @subpackage Structs
 */
class GetUAListResponse extends AbstractStructBase
{
    /**
     * The ua_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:UAInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\UAInfo[]
     */
    public $ua_list;
    /**
     * Constructor method for GetUAListResponse
     * @uses GetUAListResponse::setUa_list()
     * @param \StructType\UAInfo[] $ua_list
     */
    public function __construct(array $ua_list = array())
    {
        $this
            ->setUa_list($ua_list);
    }
    /**
     * Get ua_list value
     * @return \StructType\UAInfo[]|null
     */
    public function getUa_list()
    {
        return $this->ua_list;
    }
    /**
     * Set ua_list value
     * @throws \InvalidArgumentException
     * @param \StructType\UAInfo[] $ua_list
     * @return \StructType\GetUAListResponse
     */
    public function setUa_list(array $ua_list = array())
    {
        foreach ($ua_list as $getUAListResponseUa_listItem) {
            // validation for constraint: itemType
            if (!$getUAListResponseUa_listItem instanceof \StructType\UAInfo) {
                throw new \InvalidArgumentException(sprintf('The ua_list property can only contain items of \StructType\UAInfo, "%s" given', is_object($getUAListResponseUa_listItem) ? get_class($getUAListResponseUa_listItem) : gettype($getUAListResponseUa_listItem)), __LINE__);
            }
        }
        $this->ua_list = $ua_list;
        return $this;
    }
    /**
     * Add item to ua_list value
     * @throws \InvalidArgumentException
     * @param \StructType\UAInfo $item
     * @return \StructType\GetUAListResponse
     */
    public function addToUa_list(\StructType\UAInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UAInfo) {
            throw new \InvalidArgumentException(sprintf('The ua_list property can only contain items of \StructType\UAInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ua_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUAListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
