<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyAclForObjectsRequest StructType
 * @subpackage Structs
 */
class GetMyAclForObjectsRequest extends AbstractStructBase
{
    /**
     * The objects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - arrayType: string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $objects;
    /**
     * Constructor method for GetMyAclForObjectsRequest
     * @uses GetMyAclForObjectsRequest::setObjects()
     * @param string[] $objects
     */
    public function __construct(array $objects = array())
    {
        $this
            ->setObjects($objects);
    }
    /**
     * Get objects value
     * @return string[]
     */
    public function getObjects()
    {
        return $this->objects;
    }
    /**
     * Set objects value
     * @throws \InvalidArgumentException
     * @param string[] $objects
     * @return \StructType\GetMyAclForObjectsRequest
     */
    public function setObjects(array $objects = array())
    {
        foreach ($objects as $getMyAclForObjectsRequestObjectsItem) {
            // validation for constraint: itemType
            if (!is_string($getMyAclForObjectsRequestObjectsItem)) {
                throw new \InvalidArgumentException(sprintf('The objects property can only contain items of string, "%s" given', is_object($getMyAclForObjectsRequestObjectsItem) ? get_class($getMyAclForObjectsRequestObjectsItem) : gettype($getMyAclForObjectsRequestObjectsItem)), __LINE__);
            }
        }
        $this->objects = $objects;
        return $this;
    }
    /**
     * Add item to objects value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetMyAclForObjectsRequest
     */
    public function addToObjects($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The objects property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->objects[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMyAclForObjectsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
