<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHGListInfoRequest StructType
 * @subpackage Structs
 */
class GetHGListInfoRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The self_ref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $self_ref;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The i_c_ext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_c_ext;
    /**
     * Constructor method for GetHGListInfoRequest
     * @uses GetHGListInfoRequest::setI_customer()
     * @uses GetHGListInfoRequest::setSelf_ref()
     * @uses GetHGListInfoRequest::setLimit()
     * @uses GetHGListInfoRequest::setOffset()
     * @uses GetHGListInfoRequest::setI_c_ext()
     * @param int $i_customer
     * @param int $self_ref
     * @param int $limit
     * @param int $offset
     * @param int $i_c_ext
     */
    public function __construct($i_customer = null, $self_ref = null, $limit = null, $offset = null, $i_c_ext = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setSelf_ref($self_ref)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setI_c_ext($i_c_ext);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetHGListInfoRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get self_ref value
     * @return int|null
     */
    public function getSelf_ref()
    {
        return $this->self_ref;
    }
    /**
     * Set self_ref value
     * @param int $self_ref
     * @return \StructType\GetHGListInfoRequest
     */
    public function setSelf_ref($self_ref = null)
    {
        // validation for constraint: int
        if (!is_null($self_ref) && !is_numeric($self_ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($self_ref)), __LINE__);
        }
        $this->self_ref = $self_ref;
        return $this;
    }
    /**
     * Get limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->limit) ? $this->limit : null;
    }
    /**
     * Set limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\GetHGListInfoRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->limit);
        } else {
            $this->limit = $limit;
        }
        return $this;
    }
    /**
     * Get offset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffset()
    {
        return isset($this->offset) ? $this->offset : null;
    }
    /**
     * Set offset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offset
     * @return \StructType\GetHGListInfoRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        if (is_null($offset) || (is_array($offset) && empty($offset))) {
            unset($this->offset);
        } else {
            $this->offset = $offset;
        }
        return $this;
    }
    /**
     * Get i_c_ext value
     * @return int|null
     */
    public function getI_c_ext()
    {
        return $this->i_c_ext;
    }
    /**
     * Set i_c_ext value
     * @param int $i_c_ext
     * @return \StructType\GetHGListInfoRequest
     */
    public function setI_c_ext($i_c_ext = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_ext) && !is_numeric($i_c_ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_ext)), __LINE__);
        }
        $this->i_c_ext = $i_c_ext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHGListInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
