<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDiscountPlanListRequest StructType
 * @subpackage Structs
 */
class GetDiscountPlanListRequest extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $get_total;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * Constructor method for GetDiscountPlanListRequest
     * @uses GetDiscountPlanListRequest::setName()
     * @uses GetDiscountPlanListRequest::setI_customer()
     * @uses GetDiscountPlanListRequest::setIso_4217()
     * @uses GetDiscountPlanListRequest::setGet_total()
     * @uses GetDiscountPlanListRequest::setLimit()
     * @uses GetDiscountPlanListRequest::setOffset()
     * @param string $name
     * @param int $i_customer
     * @param string $iso_4217
     * @param int $get_total
     * @param int $limit
     * @param int $offset
     */
    public function __construct($name = null, $i_customer = null, $iso_4217 = null, $get_total = null, $limit = null, $offset = null)
    {
        $this
            ->setName($name)
            ->setI_customer($i_customer)
            ->setIso_4217($iso_4217)
            ->setGet_total($get_total)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get get_total value
     * @return int|null
     */
    public function getGet_total()
    {
        return $this->get_total;
    }
    /**
     * Set get_total value
     * @param int $get_total
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        $this->get_total = $get_total;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetDiscountPlanListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDiscountPlanListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
