<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestinationPrefixListRequest StructType
 * @subpackage Structs
 */
class GetDestinationPrefixListRequest extends AbstractStructBase
{
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The order_by_destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_by_destination;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $get_total;
    /**
     * Constructor method for GetDestinationPrefixListRequest
     * @uses GetDestinationPrefixListRequest::setOffset()
     * @uses GetDestinationPrefixListRequest::setLimit()
     * @uses GetDestinationPrefixListRequest::setDestination()
     * @uses GetDestinationPrefixListRequest::setOrder_by_destination()
     * @uses GetDestinationPrefixListRequest::setGet_total()
     * @param int $offset
     * @param int $limit
     * @param string $destination
     * @param string $order_by_destination
     * @param int $get_total
     */
    public function __construct($offset = null, $limit = null, $destination = null, $order_by_destination = null, $get_total = null)
    {
        $this
            ->setOffset($offset)
            ->setLimit($limit)
            ->setDestination($destination)
            ->setOrder_by_destination($order_by_destination)
            ->setGet_total($get_total);
    }
    /**
     * Get offset value
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get order_by_destination value
     * @return string|null
     */
    public function getOrder_by_destination()
    {
        return $this->order_by_destination;
    }
    /**
     * Set order_by_destination value
     * @param string $order_by_destination
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public function setOrder_by_destination($order_by_destination = null)
    {
        // validation for constraint: string
        if (!is_null($order_by_destination) && !is_string($order_by_destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_by_destination)), __LINE__);
        }
        $this->order_by_destination = $order_by_destination;
        return $this;
    }
    /**
     * Get get_total value
     * @return int|null
     */
    public function getGet_total()
    {
        return $this->get_total;
    }
    /**
     * Set get_total value
     * @param int $get_total
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        $this->get_total = $get_total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestinationPrefixListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
