<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestGroupListResponse StructType
 * @subpackage Structs
 */
class GetDestGroupListResponse extends AbstractStructBase
{
    /**
     * The dest_group_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:DestinationGroupInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DestinationGroupInfo[]
     */
    public $dest_group_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetDestGroupListResponse
     * @uses GetDestGroupListResponse::setDest_group_list()
     * @uses GetDestGroupListResponse::setTotal()
     * @param \StructType\DestinationGroupInfo[] $dest_group_list
     * @param int $total
     */
    public function __construct(array $dest_group_list = array(), $total = null)
    {
        $this
            ->setDest_group_list($dest_group_list)
            ->setTotal($total);
    }
    /**
     * Get dest_group_list value
     * @return \StructType\DestinationGroupInfo[]|null
     */
    public function getDest_group_list()
    {
        return $this->dest_group_list;
    }
    /**
     * Set dest_group_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationGroupInfo[] $dest_group_list
     * @return \StructType\GetDestGroupListResponse
     */
    public function setDest_group_list(array $dest_group_list = array())
    {
        foreach ($dest_group_list as $getDestGroupListResponseDest_group_listItem) {
            // validation for constraint: itemType
            if (!$getDestGroupListResponseDest_group_listItem instanceof \StructType\DestinationGroupInfo) {
                throw new \InvalidArgumentException(sprintf('The dest_group_list property can only contain items of \StructType\DestinationGroupInfo, "%s" given', is_object($getDestGroupListResponseDest_group_listItem) ? get_class($getDestGroupListResponseDest_group_listItem) : gettype($getDestGroupListResponseDest_group_listItem)), __LINE__);
            }
        }
        $this->dest_group_list = $dest_group_list;
        return $this;
    }
    /**
     * Add item to dest_group_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationGroupInfo $item
     * @return \StructType\GetDestGroupListResponse
     */
    public function addToDest_group_list(\StructType\DestinationGroupInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestinationGroupInfo) {
            throw new \InvalidArgumentException(sprintf('The dest_group_list property can only contain items of \StructType\DestinationGroupInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dest_group_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetDestGroupListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestGroupListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
