<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerTransactionsTotalInfoRequest StructType
 * @subpackage Structs
 */
class GetCustomerTransactionsTotalInfoRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The billing_model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $billing_model;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $to_date;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * Constructor method for GetCustomerTransactionsTotalInfoRequest
     * @uses GetCustomerTransactionsTotalInfoRequest::setI_customer()
     * @uses GetCustomerTransactionsTotalInfoRequest::setBilling_model()
     * @uses GetCustomerTransactionsTotalInfoRequest::setFrom_date()
     * @uses GetCustomerTransactionsTotalInfoRequest::setTo_date()
     * @uses GetCustomerTransactionsTotalInfoRequest::setI_service()
     * @param int $i_customer
     * @param int $billing_model
     * @param string $from_date
     * @param string $to_date
     * @param int $i_service
     */
    public function __construct($i_customer = null, $billing_model = null, $from_date = null, $to_date = null, $i_service = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setBilling_model($billing_model)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setI_service($i_service);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get billing_model value
     * @return int
     */
    public function getBilling_model()
    {
        return $this->billing_model;
    }
    /**
     * Set billing_model value
     * @param int $billing_model
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public function setBilling_model($billing_model = null)
    {
        // validation for constraint: int
        if (!is_null($billing_model) && !is_numeric($billing_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_model)), __LINE__);
        }
        $this->billing_model = $billing_model;
        return $this;
    }
    /**
     * Get from_date value
     * @return string
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get i_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service()
    {
        return isset($this->i_service) ? $this->i_service : null;
    }
    /**
     * Set i_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        if (is_null($i_service) || (is_array($i_service) && empty($i_service))) {
            unset($this->i_service);
        } else {
            $this->i_service = $i_service;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerTransactionsTotalInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
