<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerInfoRequest StructType
 * @subpackage Structs
 */
class GetCustomerInfoRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The refnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refnum;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The get_time_zone_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $get_time_zone_name;
    /**
     * Constructor method for GetCustomerInfoRequest
     * @uses GetCustomerInfoRequest::setI_customer()
     * @uses GetCustomerInfoRequest::setRefnum()
     * @uses GetCustomerInfoRequest::setName()
     * @uses GetCustomerInfoRequest::setLogin()
     * @uses GetCustomerInfoRequest::setGet_time_zone_name()
     * @param int $i_customer
     * @param string $refnum
     * @param string $name
     * @param string $login
     * @param int $get_time_zone_name
     */
    public function __construct($i_customer = null, $refnum = null, $name = null, $login = null, $get_time_zone_name = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setRefnum($refnum)
            ->setName($name)
            ->setLogin($login)
            ->setGet_time_zone_name($get_time_zone_name);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetCustomerInfoRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get refnum value
     * @return string|null
     */
    public function getRefnum()
    {
        return $this->refnum;
    }
    /**
     * Set refnum value
     * @param string $refnum
     * @return \StructType\GetCustomerInfoRequest
     */
    public function setRefnum($refnum = null)
    {
        // validation for constraint: string
        if (!is_null($refnum) && !is_string($refnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refnum)), __LINE__);
        }
        $this->refnum = $refnum;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetCustomerInfoRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetCustomerInfoRequest
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get get_time_zone_name value
     * @return int|null
     */
    public function getGet_time_zone_name()
    {
        return $this->get_time_zone_name;
    }
    /**
     * Set get_time_zone_name value
     * @param int $get_time_zone_name
     * @return \StructType\GetCustomerInfoRequest
     */
    public function setGet_time_zone_name($get_time_zone_name = null)
    {
        // validation for constraint: int
        if (!is_null($get_time_zone_name) && !is_numeric($get_time_zone_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_time_zone_name)), __LINE__);
        }
        $this->get_time_zone_name = $get_time_zone_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
