<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllAccAliasesListInfoResponse StructType
 * @subpackage Structs
 */
class GetAllAccAliasesListInfoResponse extends AbstractStructBase
{
    /**
     * The account_aliases_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:AccAliasesListInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AccAliasesListInfo[]
     */
    public $account_aliases_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetAllAccAliasesListInfoResponse
     * @uses GetAllAccAliasesListInfoResponse::setAccount_aliases_list()
     * @uses GetAllAccAliasesListInfoResponse::setTotal()
     * @param \StructType\AccAliasesListInfo[] $account_aliases_list
     * @param int $total
     */
    public function __construct(array $account_aliases_list = array(), $total = null)
    {
        $this
            ->setAccount_aliases_list($account_aliases_list)
            ->setTotal($total);
    }
    /**
     * Get account_aliases_list value
     * @return \StructType\AccAliasesListInfo[]|null
     */
    public function getAccount_aliases_list()
    {
        return $this->account_aliases_list;
    }
    /**
     * Set account_aliases_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AccAliasesListInfo[] $account_aliases_list
     * @return \StructType\GetAllAccAliasesListInfoResponse
     */
    public function setAccount_aliases_list(array $account_aliases_list = array())
    {
        foreach ($account_aliases_list as $getAllAccAliasesListInfoResponseAccount_aliases_listItem) {
            // validation for constraint: itemType
            if (!$getAllAccAliasesListInfoResponseAccount_aliases_listItem instanceof \StructType\AccAliasesListInfo) {
                throw new \InvalidArgumentException(sprintf('The account_aliases_list property can only contain items of \StructType\AccAliasesListInfo, "%s" given', is_object($getAllAccAliasesListInfoResponseAccount_aliases_listItem) ? get_class($getAllAccAliasesListInfoResponseAccount_aliases_listItem) : gettype($getAllAccAliasesListInfoResponseAccount_aliases_listItem)), __LINE__);
            }
        }
        $this->account_aliases_list = $account_aliases_list;
        return $this;
    }
    /**
     * Add item to account_aliases_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AccAliasesListInfo $item
     * @return \StructType\GetAllAccAliasesListInfoResponse
     */
    public function addToAccount_aliases_list(\StructType\AccAliasesListInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccAliasesListInfo) {
            throw new \InvalidArgumentException(sprintf('The account_aliases_list property can only contain items of \StructType\AccAliasesListInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->account_aliases_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetAllAccAliasesListInfoResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllAccAliasesListInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
