<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountXDRListResponse StructType
 * @subpackage Structs
 */
class GetAccountXDRListResponse extends AbstractStructBase
{
    /**
     * The xdr_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:XDRInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\XDRInfo[]
     */
    public $xdr_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetAccountXDRListResponse
     * @uses GetAccountXDRListResponse::setXdr_list()
     * @uses GetAccountXDRListResponse::setTotal()
     * @param \StructType\XDRInfo[] $xdr_list
     * @param int $total
     */
    public function __construct(array $xdr_list = array(), $total = null)
    {
        $this
            ->setXdr_list($xdr_list)
            ->setTotal($total);
    }
    /**
     * Get xdr_list value
     * @return \StructType\XDRInfo[]|null
     */
    public function getXdr_list()
    {
        return $this->xdr_list;
    }
    /**
     * Set xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\XDRInfo[] $xdr_list
     * @return \StructType\GetAccountXDRListResponse
     */
    public function setXdr_list(array $xdr_list = array())
    {
        foreach ($xdr_list as $getAccountXDRListResponseXdr_listItem) {
            // validation for constraint: itemType
            if (!$getAccountXDRListResponseXdr_listItem instanceof \StructType\XDRInfo) {
                throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\XDRInfo, "%s" given', is_object($getAccountXDRListResponseXdr_listItem) ? get_class($getAccountXDRListResponseXdr_listItem) : gettype($getAccountXDRListResponseXdr_listItem)), __LINE__);
            }
        }
        $this->xdr_list = $xdr_list;
        return $this;
    }
    /**
     * Add item to xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\XDRInfo $item
     * @return \StructType\GetAccountXDRListResponse
     */
    public function addToXdr_list(\StructType\XDRInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XDRInfo) {
            throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\XDRInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->xdr_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetAccountXDRListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountXDRListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
