<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountSubscriptionsResponse StructType
 * @subpackage Structs
 */
class GetAccountSubscriptionsResponse extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:AccountSubscriptionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AccountSubscriptionInfo[]
     */
    public $subscriptions;
    /**
     * Constructor method for GetAccountSubscriptionsResponse
     * @uses GetAccountSubscriptionsResponse::setSubscriptions()
     * @param \StructType\AccountSubscriptionInfo[] $subscriptions
     */
    public function __construct(array $subscriptions = array())
    {
        $this
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get subscriptions value
     * @return \StructType\AccountSubscriptionInfo[]|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * Set subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountSubscriptionInfo[] $subscriptions
     * @return \StructType\GetAccountSubscriptionsResponse
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        foreach ($subscriptions as $getAccountSubscriptionsResponseSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$getAccountSubscriptionsResponseSubscriptionsItem instanceof \StructType\AccountSubscriptionInfo) {
                throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\AccountSubscriptionInfo, "%s" given', is_object($getAccountSubscriptionsResponseSubscriptionsItem) ? get_class($getAccountSubscriptionsResponseSubscriptionsItem) : gettype($getAccountSubscriptionsResponseSubscriptionsItem)), __LINE__);
            }
        }
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountSubscriptionInfo $item
     * @return \StructType\GetAccountSubscriptionsResponse
     */
    public function addToSubscriptions(\StructType\AccountSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\AccountSubscriptionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountSubscriptionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
