<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountListResponse StructType
 * @subpackage Structs
 */
class GetAccountListResponse extends AbstractStructBase
{
    /**
     * The account_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:AccountInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AccountInfo[]
     */
    public $account_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetAccountListResponse
     * @uses GetAccountListResponse::setAccount_list()
     * @uses GetAccountListResponse::setTotal()
     * @param \StructType\AccountInfo[] $account_list
     * @param int $total
     */
    public function __construct(array $account_list = array(), $total = null)
    {
        $this
            ->setAccount_list($account_list)
            ->setTotal($total);
    }
    /**
     * Get account_list value
     * @return \StructType\AccountInfo[]|null
     */
    public function getAccount_list()
    {
        return $this->account_list;
    }
    /**
     * Set account_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo[] $account_list
     * @return \StructType\GetAccountListResponse
     */
    public function setAccount_list(array $account_list = array())
    {
        foreach ($account_list as $getAccountListResponseAccount_listItem) {
            // validation for constraint: itemType
            if (!$getAccountListResponseAccount_listItem instanceof \StructType\AccountInfo) {
                throw new \InvalidArgumentException(sprintf('The account_list property can only contain items of \StructType\AccountInfo, "%s" given', is_object($getAccountListResponseAccount_listItem) ? get_class($getAccountListResponseAccount_listItem) : gettype($getAccountListResponseAccount_listItem)), __LINE__);
            }
        }
        $this->account_list = $account_list;
        return $this;
    }
    /**
     * Add item to account_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountInfo $item
     * @return \StructType\GetAccountListResponse
     */
    public function addToAccount_list(\StructType\AccountInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountInfo) {
            throw new \InvalidArgumentException(sprintf('The account_list property can only contain items of \StructType\AccountInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->account_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetAccountListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
