<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountInfoRequest StructType
 * @subpackage Structs
 */
class GetAccountInfoRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The i_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_batch;
    /**
     * The control_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $control_number;
    /**
     * The batch_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $batch_name;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The detailed_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $detailed_info;
    /**
     * The expand_alias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expand_alias;
    /**
     * The without_service_features
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $without_service_features;
    /**
     * Constructor method for GetAccountInfoRequest
     * @uses GetAccountInfoRequest::setI_account()
     * @uses GetAccountInfoRequest::setI_batch()
     * @uses GetAccountInfoRequest::setControl_number()
     * @uses GetAccountInfoRequest::setBatch_name()
     * @uses GetAccountInfoRequest::setId()
     * @uses GetAccountInfoRequest::setLogin()
     * @uses GetAccountInfoRequest::setDetailed_info()
     * @uses GetAccountInfoRequest::setExpand_alias()
     * @uses GetAccountInfoRequest::setWithout_service_features()
     * @param int $i_account
     * @param int $i_batch
     * @param int $control_number
     * @param string $batch_name
     * @param string $id
     * @param string $login
     * @param int $detailed_info
     * @param int $expand_alias
     * @param int $without_service_features
     */
    public function __construct($i_account = null, $i_batch = null, $control_number = null, $batch_name = null, $id = null, $login = null, $detailed_info = null, $expand_alias = null, $without_service_features = null)
    {
        $this
            ->setI_account($i_account)
            ->setI_batch($i_batch)
            ->setControl_number($control_number)
            ->setBatch_name($batch_name)
            ->setId($id)
            ->setLogin($login)
            ->setDetailed_info($detailed_info)
            ->setExpand_alias($expand_alias)
            ->setWithout_service_features($without_service_features);
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\GetAccountInfoRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_batch value
     * @return int|null
     */
    public function getI_batch()
    {
        return $this->i_batch;
    }
    /**
     * Set i_batch value
     * @param int $i_batch
     * @return \StructType\GetAccountInfoRequest
     */
    public function setI_batch($i_batch = null)
    {
        // validation for constraint: int
        if (!is_null($i_batch) && !is_numeric($i_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_batch)), __LINE__);
        }
        $this->i_batch = $i_batch;
        return $this;
    }
    /**
     * Get control_number value
     * @return int|null
     */
    public function getControl_number()
    {
        return $this->control_number;
    }
    /**
     * Set control_number value
     * @param int $control_number
     * @return \StructType\GetAccountInfoRequest
     */
    public function setControl_number($control_number = null)
    {
        // validation for constraint: int
        if (!is_null($control_number) && !is_numeric($control_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($control_number)), __LINE__);
        }
        $this->control_number = $control_number;
        return $this;
    }
    /**
     * Get batch_name value
     * @return string|null
     */
    public function getBatch_name()
    {
        return $this->batch_name;
    }
    /**
     * Set batch_name value
     * @param string $batch_name
     * @return \StructType\GetAccountInfoRequest
     */
    public function setBatch_name($batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($batch_name) && !is_string($batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batch_name)), __LINE__);
        }
        $this->batch_name = $batch_name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetAccountInfoRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetAccountInfoRequest
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get detailed_info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDetailed_info()
    {
        return isset($this->detailed_info) ? $this->detailed_info : null;
    }
    /**
     * Set detailed_info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $detailed_info
     * @return \StructType\GetAccountInfoRequest
     */
    public function setDetailed_info($detailed_info = null)
    {
        // validation for constraint: int
        if (!is_null($detailed_info) && !is_numeric($detailed_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($detailed_info)), __LINE__);
        }
        if (is_null($detailed_info) || (is_array($detailed_info) && empty($detailed_info))) {
            unset($this->detailed_info);
        } else {
            $this->detailed_info = $detailed_info;
        }
        return $this;
    }
    /**
     * Get expand_alias value
     * @return int|null
     */
    public function getExpand_alias()
    {
        return $this->expand_alias;
    }
    /**
     * Set expand_alias value
     * @param int $expand_alias
     * @return \StructType\GetAccountInfoRequest
     */
    public function setExpand_alias($expand_alias = null)
    {
        // validation for constraint: int
        if (!is_null($expand_alias) && !is_numeric($expand_alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expand_alias)), __LINE__);
        }
        $this->expand_alias = $expand_alias;
        return $this;
    }
    /**
     * Get without_service_features value
     * @return int|null
     */
    public function getWithout_service_features()
    {
        return $this->without_service_features;
    }
    /**
     * Set without_service_features value
     * @param int $without_service_features
     * @return \StructType\GetAccountInfoRequest
     */
    public function setWithout_service_features($without_service_features = null)
    {
        // validation for constraint: int
        if (!is_null($without_service_features) && !is_numeric($without_service_features)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($without_service_features)), __LINE__);
        }
        $this->without_service_features = $without_service_features;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
