<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountConsumedServiceResponse StructType
 * @subpackage Structs
 */
class GetAccountConsumedServiceResponse extends AbstractStructBase
{
    /**
     * The consumed_service_list
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: pst:ConsumedServiceInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ConsumedServiceInfo[]
     */
    public $consumed_service_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetAccountConsumedServiceResponse
     * @uses GetAccountConsumedServiceResponse::setConsumed_service_list()
     * @uses GetAccountConsumedServiceResponse::setTotal()
     * @param \StructType\ConsumedServiceInfo[] $consumed_service_list
     * @param int $total
     */
    public function __construct(array $consumed_service_list = array(), $total = null)
    {
        $this
            ->setConsumed_service_list($consumed_service_list)
            ->setTotal($total);
    }
    /**
     * Get consumed_service_list value
     * @return \StructType\ConsumedServiceInfo[]|null
     */
    public function getConsumed_service_list()
    {
        return $this->consumed_service_list;
    }
    /**
     * Set consumed_service_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsumedServiceInfo[] $consumed_service_list
     * @return \StructType\GetAccountConsumedServiceResponse
     */
    public function setConsumed_service_list(array $consumed_service_list = array())
    {
        foreach ($consumed_service_list as $getAccountConsumedServiceResponseConsumed_service_listItem) {
            // validation for constraint: itemType
            if (!$getAccountConsumedServiceResponseConsumed_service_listItem instanceof \StructType\ConsumedServiceInfo) {
                throw new \InvalidArgumentException(sprintf('The consumed_service_list property can only contain items of \StructType\ConsumedServiceInfo, "%s" given', is_object($getAccountConsumedServiceResponseConsumed_service_listItem) ? get_class($getAccountConsumedServiceResponseConsumed_service_listItem) : gettype($getAccountConsumedServiceResponseConsumed_service_listItem)), __LINE__);
            }
        }
        $this->consumed_service_list = $consumed_service_list;
        return $this;
    }
    /**
     * Add item to consumed_service_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsumedServiceInfo $item
     * @return \StructType\GetAccountConsumedServiceResponse
     */
    public function addToConsumed_service_list(\StructType\ConsumedServiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsumedServiceInfo) {
            throw new \InvalidArgumentException(sprintf('The consumed_service_list property can only contain items of \StructType\ConsumedServiceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->consumed_service_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetAccountConsumedServiceResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountConsumedServiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
