<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDProviderInfo StructType
 * @subpackage Structs
 */
class DIDProviderInfo extends AbstractStructBase
{
    /**
     * The is_numbers_list_available
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $is_numbers_list_available;
    /**
     * The provider_currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $provider_currency;
    /**
     * Constructor method for DIDProviderInfo
     * @uses DIDProviderInfo::setIs_numbers_list_available()
     * @uses DIDProviderInfo::setProvider_currency()
     * @param int $is_numbers_list_available
     * @param string $provider_currency
     */
    public function __construct($is_numbers_list_available = null, $provider_currency = null)
    {
        $this
            ->setIs_numbers_list_available($is_numbers_list_available)
            ->setProvider_currency($provider_currency);
    }
    /**
     * Get is_numbers_list_available value
     * @return int
     */
    public function getIs_numbers_list_available()
    {
        return $this->is_numbers_list_available;
    }
    /**
     * Set is_numbers_list_available value
     * @param int $is_numbers_list_available
     * @return \StructType\DIDProviderInfo
     */
    public function setIs_numbers_list_available($is_numbers_list_available = null)
    {
        // validation for constraint: int
        if (!is_null($is_numbers_list_available) && !is_numeric($is_numbers_list_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_numbers_list_available)), __LINE__);
        }
        $this->is_numbers_list_available = $is_numbers_list_available;
        return $this;
    }
    /**
     * Get provider_currency value
     * @return string
     */
    public function getProvider_currency()
    {
        return $this->provider_currency;
    }
    /**
     * Set provider_currency value
     * @param string $provider_currency
     * @return \StructType\DIDProviderInfo
     */
    public function setProvider_currency($provider_currency = null)
    {
        // validation for constraint: string
        if (!is_null($provider_currency) && !is_string($provider_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_currency)), __LINE__);
        }
        $this->provider_currency = $provider_currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDProviderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
