<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDNumberInfo StructType
 * @subpackage Structs
 */
class DIDNumberInfo extends AbstractStructBase
{
    /**
     * The i_did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_did_number;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The owner_batch_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $owner_batch_name;
    /**
     * The vendor_batch_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendor_batch_name;
    /**
     * The reserved
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserved;
    /**
     * The reserved_stamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserved_stamp;
    /**
     * The released
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $released;
    /**
     * The assigned
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $assigned;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * Constructor method for DIDNumberInfo
     * @uses DIDNumberInfo::setI_did_number()
     * @uses DIDNumberInfo::setNumber()
     * @uses DIDNumberInfo::setDescription()
     * @uses DIDNumberInfo::setOwner_batch_name()
     * @uses DIDNumberInfo::setVendor_batch_name()
     * @uses DIDNumberInfo::setReserved()
     * @uses DIDNumberInfo::setReserved_stamp()
     * @uses DIDNumberInfo::setReleased()
     * @uses DIDNumberInfo::setAssigned()
     * @uses DIDNumberInfo::setI_account()
     * @param int $i_did_number
     * @param string $number
     * @param string $description
     * @param string $owner_batch_name
     * @param string $vendor_batch_name
     * @param string $reserved
     * @param string $reserved_stamp
     * @param string $released
     * @param string $assigned
     * @param int $i_account
     */
    public function __construct($i_did_number = null, $number = null, $description = null, $owner_batch_name = null, $vendor_batch_name = null, $reserved = null, $reserved_stamp = null, $released = null, $assigned = null, $i_account = null)
    {
        $this
            ->setI_did_number($i_did_number)
            ->setNumber($number)
            ->setDescription($description)
            ->setOwner_batch_name($owner_batch_name)
            ->setVendor_batch_name($vendor_batch_name)
            ->setReserved($reserved)
            ->setReserved_stamp($reserved_stamp)
            ->setReleased($released)
            ->setAssigned($assigned)
            ->setI_account($i_account);
    }
    /**
     * Get i_did_number value
     * @return int|null
     */
    public function getI_did_number()
    {
        return $this->i_did_number;
    }
    /**
     * Set i_did_number value
     * @param int $i_did_number
     * @return \StructType\DIDNumberInfo
     */
    public function setI_did_number($i_did_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_did_number) && !is_numeric($i_did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_did_number)), __LINE__);
        }
        $this->i_did_number = $i_did_number;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\DIDNumberInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DIDNumberInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get owner_batch_name value
     * @return string|null
     */
    public function getOwner_batch_name()
    {
        return $this->owner_batch_name;
    }
    /**
     * Set owner_batch_name value
     * @param string $owner_batch_name
     * @return \StructType\DIDNumberInfo
     */
    public function setOwner_batch_name($owner_batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($owner_batch_name) && !is_string($owner_batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner_batch_name)), __LINE__);
        }
        $this->owner_batch_name = $owner_batch_name;
        return $this;
    }
    /**
     * Get vendor_batch_name value
     * @return string|null
     */
    public function getVendor_batch_name()
    {
        return $this->vendor_batch_name;
    }
    /**
     * Set vendor_batch_name value
     * @param string $vendor_batch_name
     * @return \StructType\DIDNumberInfo
     */
    public function setVendor_batch_name($vendor_batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($vendor_batch_name) && !is_string($vendor_batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendor_batch_name)), __LINE__);
        }
        $this->vendor_batch_name = $vendor_batch_name;
        return $this;
    }
    /**
     * Get reserved value
     * @return string|null
     */
    public function getReserved()
    {
        return $this->reserved;
    }
    /**
     * Set reserved value
     * @param string $reserved
     * @return \StructType\DIDNumberInfo
     */
    public function setReserved($reserved = null)
    {
        // validation for constraint: string
        if (!is_null($reserved) && !is_string($reserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserved)), __LINE__);
        }
        $this->reserved = $reserved;
        return $this;
    }
    /**
     * Get reserved_stamp value
     * @return string|null
     */
    public function getReserved_stamp()
    {
        return $this->reserved_stamp;
    }
    /**
     * Set reserved_stamp value
     * @param string $reserved_stamp
     * @return \StructType\DIDNumberInfo
     */
    public function setReserved_stamp($reserved_stamp = null)
    {
        // validation for constraint: string
        if (!is_null($reserved_stamp) && !is_string($reserved_stamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserved_stamp)), __LINE__);
        }
        $this->reserved_stamp = $reserved_stamp;
        return $this;
    }
    /**
     * Get released value
     * @return string|null
     */
    public function getReleased()
    {
        return $this->released;
    }
    /**
     * Set released value
     * @param string $released
     * @return \StructType\DIDNumberInfo
     */
    public function setReleased($released = null)
    {
        // validation for constraint: string
        if (!is_null($released) && !is_string($released)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($released)), __LINE__);
        }
        $this->released = $released;
        return $this;
    }
    /**
     * Get assigned value
     * @return string|null
     */
    public function getAssigned()
    {
        return $this->assigned;
    }
    /**
     * Set assigned value
     * @param string $assigned
     * @return \StructType\DIDNumberInfo
     */
    public function setAssigned($assigned = null)
    {
        // validation for constraint: string
        if (!is_null($assigned) && !is_string($assigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assigned)), __LINE__);
        }
        $this->assigned = $assigned;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\DIDNumberInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDNumberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
