<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRegisterTransactionRequest StructType
 * @subpackage Structs
 */
class CustomerRegisterTransactionRequest extends AbstractStructBase
{
    /**
     * The i_payment_method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_payment_method;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * Constructor method for CustomerRegisterTransactionRequest
     * @uses CustomerRegisterTransactionRequest::setI_payment_method()
     * @uses CustomerRegisterTransactionRequest::setAmount()
     * @uses CustomerRegisterTransactionRequest::setI_customer()
     * @param int $i_payment_method
     * @param float $amount
     * @param int $i_customer
     */
    public function __construct($i_payment_method = null, $amount = null, $i_customer = null)
    {
        $this
            ->setI_payment_method($i_payment_method)
            ->setAmount($amount)
            ->setI_customer($i_customer);
    }
    /**
     * Get i_payment_method value
     * @return int
     */
    public function getI_payment_method()
    {
        return $this->i_payment_method;
    }
    /**
     * Set i_payment_method value
     * @param int $i_payment_method
     * @return \StructType\CustomerRegisterTransactionRequest
     */
    public function setI_payment_method($i_payment_method = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_method) && !is_numeric($i_payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_method)), __LINE__);
        }
        $this->i_payment_method = $i_payment_method;
        return $this;
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomerRegisterTransactionRequest
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerRegisterTransactionRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerRegisterTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
