<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldsValuesInfo StructType
 * @subpackage Structs
 */
class CustomFieldsValuesInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The text_value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $text_value;
    /**
     * The db_value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $db_value;
    /**
     * Constructor method for CustomFieldsValuesInfo
     * @uses CustomFieldsValuesInfo::setName()
     * @uses CustomFieldsValuesInfo::setText_value()
     * @uses CustomFieldsValuesInfo::setDb_value()
     * @param string $name
     * @param string $text_value
     * @param string $db_value
     */
    public function __construct($name = null, $text_value = null, $db_value = null)
    {
        $this
            ->setName($name)
            ->setText_value($text_value)
            ->setDb_value($db_value);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomFieldsValuesInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get text_value value
     * @return string
     */
    public function getText_value()
    {
        return $this->text_value;
    }
    /**
     * Set text_value value
     * @param string $text_value
     * @return \StructType\CustomFieldsValuesInfo
     */
    public function setText_value($text_value = null)
    {
        // validation for constraint: string
        if (!is_null($text_value) && !is_string($text_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text_value)), __LINE__);
        }
        $this->text_value = $text_value;
        return $this;
    }
    /**
     * Get db_value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDb_value()
    {
        return isset($this->db_value) ? $this->db_value : null;
    }
    /**
     * Set db_value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $db_value
     * @return \StructType\CustomFieldsValuesInfo
     */
    public function setDb_value($db_value = null)
    {
        // validation for constraint: string
        if (!is_null($db_value) && !is_string($db_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($db_value)), __LINE__);
        }
        if (is_null($db_value) || (is_array($db_value) && empty($db_value))) {
            unset($this->db_value);
        } else {
            $this->db_value = $db_value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomFieldsValuesInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
