<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldsInfo StructType
 * @subpackage Structs
 */
class CustomFieldsInfo extends AbstractStructBase
{
    /**
     * The mandatory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mandatory;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The default_value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $default_value;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $properties;
    /**
     * Constructor method for CustomFieldsInfo
     * @uses CustomFieldsInfo::setMandatory()
     * @uses CustomFieldsInfo::setName()
     * @uses CustomFieldsInfo::setType()
     * @uses CustomFieldsInfo::setDefault_value()
     * @uses CustomFieldsInfo::setValue()
     * @uses CustomFieldsInfo::setProperties()
     * @param string $mandatory
     * @param string $name
     * @param string $type
     * @param string $default_value
     * @param string $value
     * @param string $properties
     */
    public function __construct($mandatory = null, $name = null, $type = null, $default_value = null, $value = null, $properties = null)
    {
        $this
            ->setMandatory($mandatory)
            ->setName($name)
            ->setType($type)
            ->setDefault_value($default_value)
            ->setValue($value)
            ->setProperties($properties);
    }
    /**
     * Get mandatory value
     * @return string
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param string $mandatory
     * @return \StructType\CustomFieldsInfo
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: string
        if (!is_null($mandatory) && !is_string($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomFieldsInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CustomFieldsInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get default_value value
     * @return string|null
     */
    public function getDefault_value()
    {
        return $this->default_value;
    }
    /**
     * Set default_value value
     * @param string $default_value
     * @return \StructType\CustomFieldsInfo
     */
    public function setDefault_value($default_value = null)
    {
        // validation for constraint: string
        if (!is_null($default_value) && !is_string($default_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_value)), __LINE__);
        }
        $this->default_value = $default_value;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\CustomFieldsInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get properties value
     * @return string|null
     */
    public function getProperties()
    {
        return $this->properties;
    }
    /**
     * Set properties value
     * @param string $properties
     * @return \StructType\CustomFieldsInfo
     */
    public function setProperties($properties = null)
    {
        // validation for constraint: string
        if (!is_null($properties) && !is_string($properties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($properties)), __LINE__);
        }
        $this->properties = $properties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomFieldsInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
