<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyInfo StructType
 * @subpackage Structs
 */
class CurrencyInfo extends AbstractStructBase
{
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $iso_4217;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The name_major
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name_major;
    /**
     * The name_minor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name_minor;
    /**
     * The i_x_rate_source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_x_rate_source;
    /**
     * The i_ma_currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_ma_currency;
    /**
     * The i_merchant_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_merchant_account;
    /**
     * The base_units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $base_units;
    /**
     * The min_allowed_payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $min_allowed_payment;
    /**
     * Constructor method for CurrencyInfo
     * @uses CurrencyInfo::setIso_4217()
     * @uses CurrencyInfo::setName()
     * @uses CurrencyInfo::setName_major()
     * @uses CurrencyInfo::setName_minor()
     * @uses CurrencyInfo::setI_x_rate_source()
     * @uses CurrencyInfo::setI_ma_currency()
     * @uses CurrencyInfo::setI_merchant_account()
     * @uses CurrencyInfo::setBase_units()
     * @uses CurrencyInfo::setMin_allowed_payment()
     * @param string $iso_4217
     * @param string $name
     * @param string $name_major
     * @param string $name_minor
     * @param int $i_x_rate_source
     * @param int $i_ma_currency
     * @param int $i_merchant_account
     * @param float $base_units
     * @param float $min_allowed_payment
     */
    public function __construct($iso_4217 = null, $name = null, $name_major = null, $name_minor = null, $i_x_rate_source = null, $i_ma_currency = null, $i_merchant_account = null, $base_units = null, $min_allowed_payment = null)
    {
        $this
            ->setIso_4217($iso_4217)
            ->setName($name)
            ->setName_major($name_major)
            ->setName_minor($name_minor)
            ->setI_x_rate_source($i_x_rate_source)
            ->setI_ma_currency($i_ma_currency)
            ->setI_merchant_account($i_merchant_account)
            ->setBase_units($base_units)
            ->setMin_allowed_payment($min_allowed_payment);
    }
    /**
     * Get iso_4217 value
     * @return string
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\CurrencyInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CurrencyInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get name_major value
     * @return string|null
     */
    public function getName_major()
    {
        return $this->name_major;
    }
    /**
     * Set name_major value
     * @param string $name_major
     * @return \StructType\CurrencyInfo
     */
    public function setName_major($name_major = null)
    {
        // validation for constraint: string
        if (!is_null($name_major) && !is_string($name_major)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name_major)), __LINE__);
        }
        $this->name_major = $name_major;
        return $this;
    }
    /**
     * Get name_minor value
     * @return string|null
     */
    public function getName_minor()
    {
        return $this->name_minor;
    }
    /**
     * Set name_minor value
     * @param string $name_minor
     * @return \StructType\CurrencyInfo
     */
    public function setName_minor($name_minor = null)
    {
        // validation for constraint: string
        if (!is_null($name_minor) && !is_string($name_minor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name_minor)), __LINE__);
        }
        $this->name_minor = $name_minor;
        return $this;
    }
    /**
     * Get i_x_rate_source value
     * @return int|null
     */
    public function getI_x_rate_source()
    {
        return $this->i_x_rate_source;
    }
    /**
     * Set i_x_rate_source value
     * @param int $i_x_rate_source
     * @return \StructType\CurrencyInfo
     */
    public function setI_x_rate_source($i_x_rate_source = null)
    {
        // validation for constraint: int
        if (!is_null($i_x_rate_source) && !is_numeric($i_x_rate_source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_x_rate_source)), __LINE__);
        }
        $this->i_x_rate_source = $i_x_rate_source;
        return $this;
    }
    /**
     * Get i_ma_currency value
     * @return int|null
     */
    public function getI_ma_currency()
    {
        return $this->i_ma_currency;
    }
    /**
     * Set i_ma_currency value
     * @param int $i_ma_currency
     * @return \StructType\CurrencyInfo
     */
    public function setI_ma_currency($i_ma_currency = null)
    {
        // validation for constraint: int
        if (!is_null($i_ma_currency) && !is_numeric($i_ma_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ma_currency)), __LINE__);
        }
        $this->i_ma_currency = $i_ma_currency;
        return $this;
    }
    /**
     * Get i_merchant_account value
     * @return int|null
     */
    public function getI_merchant_account()
    {
        return $this->i_merchant_account;
    }
    /**
     * Set i_merchant_account value
     * @param int $i_merchant_account
     * @return \StructType\CurrencyInfo
     */
    public function setI_merchant_account($i_merchant_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_merchant_account) && !is_numeric($i_merchant_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_merchant_account)), __LINE__);
        }
        $this->i_merchant_account = $i_merchant_account;
        return $this;
    }
    /**
     * Get base_units value
     * @return float|null
     */
    public function getBase_units()
    {
        return $this->base_units;
    }
    /**
     * Set base_units value
     * @param float $base_units
     * @return \StructType\CurrencyInfo
     */
    public function setBase_units($base_units = null)
    {
        $this->base_units = $base_units;
        return $this;
    }
    /**
     * Get min_allowed_payment value
     * @return float|null
     */
    public function getMin_allowed_payment()
    {
        return $this->min_allowed_payment;
    }
    /**
     * Set min_allowed_payment value
     * @param float $min_allowed_payment
     * @return \StructType\CurrencyInfo
     */
    public function setMin_allowed_payment($min_allowed_payment = null)
    {
        $this->min_allowed_payment = $min_allowed_payment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
