<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryInfo StructType
 * @subpackage Structs
 */
class CountryInfo extends AbstractStructBase
{
    /**
     * The iso_3166_1_a2
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $iso_3166_1_a2;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for CountryInfo
     * @uses CountryInfo::setIso_3166_1_a2()
     * @uses CountryInfo::setName()
     * @param string $iso_3166_1_a2
     * @param string $name
     */
    public function __construct($iso_3166_1_a2 = null, $name = null)
    {
        $this
            ->setIso_3166_1_a2($iso_3166_1_a2)
            ->setName($name);
    }
    /**
     * Get iso_3166_1_a2 value
     * @return string
     */
    public function getIso_3166_1_a2()
    {
        return $this->iso_3166_1_a2;
    }
    /**
     * Set iso_3166_1_a2 value
     * @param string $iso_3166_1_a2
     * @return \StructType\CountryInfo
     */
    public function setIso_3166_1_a2($iso_3166_1_a2 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_1_a2) && !is_string($iso_3166_1_a2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_1_a2)), __LINE__);
        }
        $this->iso_3166_1_a2 = $iso_3166_1_a2;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CountryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
