<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelDIDAssignmentRequest StructType
 * @subpackage Structs
 */
class CancelDIDAssignmentRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The i_did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_did_number;
    /**
     * Constructor method for CancelDIDAssignmentRequest
     * @uses CancelDIDAssignmentRequest::setI_customer()
     * @uses CancelDIDAssignmentRequest::setI_did_number()
     * @param int $i_customer
     * @param int $i_did_number
     */
    public function __construct($i_customer = null, $i_did_number = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setI_did_number($i_did_number);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CancelDIDAssignmentRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_did_number value
     * @return int
     */
    public function getI_did_number()
    {
        return $this->i_did_number;
    }
    /**
     * Set i_did_number value
     * @param int $i_did_number
     * @return \StructType\CancelDIDAssignmentRequest
     */
    public function setI_did_number($i_did_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_did_number) && !is_numeric($i_did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_did_number)), __LINE__);
        }
        $this->i_did_number = $i_did_number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelDIDAssignmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
