<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CPConditionInfo StructType
 * @subpackage Structs
 */
class CPConditionInfo extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The i_cp_condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_cp_condition;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The numbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CPConditionNumberInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CPConditionNumberInfo[]
     */
    public $numbers;
    /**
     * The time_window
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CPConditionTimeWindowInfo
     */
    public $time_window;
    /**
     * The is_used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_used;
    /**
     * Constructor method for CPConditionInfo
     * @uses CPConditionInfo::setI_account()
     * @uses CPConditionInfo::setType()
     * @uses CPConditionInfo::setI_cp_condition()
     * @uses CPConditionInfo::setName()
     * @uses CPConditionInfo::setNumbers()
     * @uses CPConditionInfo::setTime_window()
     * @uses CPConditionInfo::setIs_used()
     * @param int $i_account
     * @param string $type
     * @param int $i_cp_condition
     * @param string $name
     * @param \StructType\CPConditionNumberInfo[] $numbers
     * @param \StructType\CPConditionTimeWindowInfo $time_window
     * @param string $is_used
     */
    public function __construct($i_account = null, $type = null, $i_cp_condition = null, $name = null, array $numbers = array(), \StructType\CPConditionTimeWindowInfo $time_window = null, $is_used = null)
    {
        $this
            ->setI_account($i_account)
            ->setType($type)
            ->setI_cp_condition($i_cp_condition)
            ->setName($name)
            ->setNumbers($numbers)
            ->setTime_window($time_window)
            ->setIs_used($is_used);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\CPConditionInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CPConditionInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get i_cp_condition value
     * @return int|null
     */
    public function getI_cp_condition()
    {
        return $this->i_cp_condition;
    }
    /**
     * Set i_cp_condition value
     * @param int $i_cp_condition
     * @return \StructType\CPConditionInfo
     */
    public function setI_cp_condition($i_cp_condition = null)
    {
        // validation for constraint: int
        if (!is_null($i_cp_condition) && !is_numeric($i_cp_condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_cp_condition)), __LINE__);
        }
        $this->i_cp_condition = $i_cp_condition;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CPConditionInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get numbers value
     * @return \StructType\CPConditionNumberInfo[]|null
     */
    public function getNumbers()
    {
        return $this->numbers;
    }
    /**
     * Set numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\CPConditionNumberInfo[] $numbers
     * @return \StructType\CPConditionInfo
     */
    public function setNumbers(array $numbers = array())
    {
        foreach ($numbers as $cPConditionInfoNumbersItem) {
            // validation for constraint: itemType
            if (!$cPConditionInfoNumbersItem instanceof \StructType\CPConditionNumberInfo) {
                throw new \InvalidArgumentException(sprintf('The numbers property can only contain items of \StructType\CPConditionNumberInfo, "%s" given', is_object($cPConditionInfoNumbersItem) ? get_class($cPConditionInfoNumbersItem) : gettype($cPConditionInfoNumbersItem)), __LINE__);
            }
        }
        $this->numbers = $numbers;
        return $this;
    }
    /**
     * Add item to numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\CPConditionNumberInfo $item
     * @return \StructType\CPConditionInfo
     */
    public function addToNumbers(\StructType\CPConditionNumberInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CPConditionNumberInfo) {
            throw new \InvalidArgumentException(sprintf('The numbers property can only contain items of \StructType\CPConditionNumberInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->numbers[] = $item;
        return $this;
    }
    /**
     * Get time_window value
     * @return \StructType\CPConditionTimeWindowInfo|null
     */
    public function getTime_window()
    {
        return $this->time_window;
    }
    /**
     * Set time_window value
     * @param \StructType\CPConditionTimeWindowInfo $time_window
     * @return \StructType\CPConditionInfo
     */
    public function setTime_window(\StructType\CPConditionTimeWindowInfo $time_window = null)
    {
        $this->time_window = $time_window;
        return $this;
    }
    /**
     * Get is_used value
     * @return string|null
     */
    public function getIs_used()
    {
        return $this->is_used;
    }
    /**
     * Set is_used value
     * @param string $is_used
     * @return \StructType\CPConditionInfo
     */
    public function setIs_used($is_used = null)
    {
        // validation for constraint: string
        if (!is_null($is_used) && !is_string($is_used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_used)), __LINE__);
        }
        $this->is_used = $is_used;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CPConditionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
