<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerSubscriptionRequest StructType
 * @subpackage Structs
 */
class AddCustomerSubscriptionRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The subscription_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CustomerSubscriptionInfo
     */
    public $subscription_info;
    /**
     * Constructor method for AddCustomerSubscriptionRequest
     * @uses AddCustomerSubscriptionRequest::setI_customer()
     * @uses AddCustomerSubscriptionRequest::setSubscription_info()
     * @param int $i_customer
     * @param \StructType\CustomerSubscriptionInfo $subscription_info
     */
    public function __construct($i_customer = null, \StructType\CustomerSubscriptionInfo $subscription_info = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setSubscription_info($subscription_info);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\AddCustomerSubscriptionRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get subscription_info value
     * @return \StructType\CustomerSubscriptionInfo
     */
    public function getSubscription_info()
    {
        return $this->subscription_info;
    }
    /**
     * Set subscription_info value
     * @param \StructType\CustomerSubscriptionInfo $subscription_info
     * @return \StructType\AddCustomerSubscriptionRequest
     */
    public function setSubscription_info(\StructType\CustomerSubscriptionInfo $subscription_info = null)
    {
        $this->subscription_info = $subscription_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddCustomerSubscriptionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
