<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActiveCallInfo StructType
 * @subpackage Structs
 */
class ActiveCallInfo extends AbstractStructBase
{
    /**
     * The call_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $call_id;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $id;
    /**
     * The connect_time
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $connect_time;
    /**
     * The CLI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CLI;
    /**
     * The CLD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CLD;
    /**
     * The leg_origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $leg_origin;
    /**
     * The leg_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $leg_type;
    /**
     * Constructor method for ActiveCallInfo
     * @uses ActiveCallInfo::setCall_id()
     * @uses ActiveCallInfo::setId()
     * @uses ActiveCallInfo::setConnect_time()
     * @uses ActiveCallInfo::setCLI()
     * @uses ActiveCallInfo::setCLD()
     * @uses ActiveCallInfo::setLeg_origin()
     * @uses ActiveCallInfo::setLeg_type()
     * @param string $call_id
     * @param string $id
     * @param string $connect_time
     * @param string $cLI
     * @param string $cLD
     * @param string $leg_origin
     * @param string $leg_type
     */
    public function __construct($call_id = null, $id = null, $connect_time = null, $cLI = null, $cLD = null, $leg_origin = null, $leg_type = null)
    {
        $this
            ->setCall_id($call_id)
            ->setId($id)
            ->setConnect_time($connect_time)
            ->setCLI($cLI)
            ->setCLD($cLD)
            ->setLeg_origin($leg_origin)
            ->setLeg_type($leg_type);
    }
    /**
     * Get call_id value
     * @return string
     */
    public function getCall_id()
    {
        return $this->call_id;
    }
    /**
     * Set call_id value
     * @param string $call_id
     * @return \StructType\ActiveCallInfo
     */
    public function setCall_id($call_id = null)
    {
        // validation for constraint: string
        if (!is_null($call_id) && !is_string($call_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($call_id)), __LINE__);
        }
        $this->call_id = $call_id;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ActiveCallInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get connect_time value
     * @return string
     */
    public function getConnect_time()
    {
        return $this->connect_time;
    }
    /**
     * Set connect_time value
     * @param string $connect_time
     * @return \StructType\ActiveCallInfo
     */
    public function setConnect_time($connect_time = null)
    {
        // validation for constraint: string
        if (!is_null($connect_time) && !is_string($connect_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connect_time)), __LINE__);
        }
        $this->connect_time = $connect_time;
        return $this;
    }
    /**
     * Get CLI value
     * @return string|null
     */
    public function getCLI()
    {
        return $this->CLI;
    }
    /**
     * Set CLI value
     * @param string $cLI
     * @return \StructType\ActiveCallInfo
     */
    public function setCLI($cLI = null)
    {
        // validation for constraint: string
        if (!is_null($cLI) && !is_string($cLI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLI)), __LINE__);
        }
        $this->CLI = $cLI;
        return $this;
    }
    /**
     * Get CLD value
     * @return string|null
     */
    public function getCLD()
    {
        return $this->CLD;
    }
    /**
     * Set CLD value
     * @param string $cLD
     * @return \StructType\ActiveCallInfo
     */
    public function setCLD($cLD = null)
    {
        // validation for constraint: string
        if (!is_null($cLD) && !is_string($cLD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLD)), __LINE__);
        }
        $this->CLD = $cLD;
        return $this;
    }
    /**
     * Get leg_origin value
     * @return string|null
     */
    public function getLeg_origin()
    {
        return $this->leg_origin;
    }
    /**
     * Set leg_origin value
     * @param string $leg_origin
     * @return \StructType\ActiveCallInfo
     */
    public function setLeg_origin($leg_origin = null)
    {
        // validation for constraint: string
        if (!is_null($leg_origin) && !is_string($leg_origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leg_origin)), __LINE__);
        }
        $this->leg_origin = $leg_origin;
        return $this;
    }
    /**
     * Get leg_type value
     * @return string|null
     */
    public function getLeg_type()
    {
        return $this->leg_type;
    }
    /**
     * Set leg_type value
     * @param string $leg_type
     * @return \StructType\ActiveCallInfo
     */
    public function setLeg_type($leg_type = null)
    {
        // validation for constraint: string
        if (!is_null($leg_type) && !is_string($leg_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leg_type)), __LINE__);
        }
        $this->leg_type = $leg_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActiveCallInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
