<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSubscriptionInfo StructType
 * @subpackage Structs
 */
class AccountSubscriptionInfo extends AbstractStructBase
{
    /**
     * The i_account_subscription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account_subscription;
    /**
     * The i_subscription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_subscription;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The discount_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount_rate;
    /**
     * The start_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $start_date;
    /**
     * The activation_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activation_date;
    /**
     * The billed_to
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billed_to;
    /**
     * The finish_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $finish_date;
    /**
     * The is_finished
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_finished;
    /**
     * The obligatory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $obligatory;
    /**
     * The int_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $int_status;
    /**
     * The effective_fee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $effective_fee;
    /**
     * Constructor method for AccountSubscriptionInfo
     * @uses AccountSubscriptionInfo::setI_account_subscription()
     * @uses AccountSubscriptionInfo::setI_subscription()
     * @uses AccountSubscriptionInfo::setName()
     * @uses AccountSubscriptionInfo::setDiscount_rate()
     * @uses AccountSubscriptionInfo::setStart_date()
     * @uses AccountSubscriptionInfo::setActivation_date()
     * @uses AccountSubscriptionInfo::setBilled_to()
     * @uses AccountSubscriptionInfo::setFinish_date()
     * @uses AccountSubscriptionInfo::setIs_finished()
     * @uses AccountSubscriptionInfo::setObligatory()
     * @uses AccountSubscriptionInfo::setInt_status()
     * @uses AccountSubscriptionInfo::setEffective_fee()
     * @param int $i_account_subscription
     * @param int $i_subscription
     * @param string $name
     * @param float $discount_rate
     * @param string $start_date
     * @param string $activation_date
     * @param string $billed_to
     * @param string $finish_date
     * @param string $is_finished
     * @param string $obligatory
     * @param int $int_status
     * @param float $effective_fee
     */
    public function __construct($i_account_subscription = null, $i_subscription = null, $name = null, $discount_rate = null, $start_date = null, $activation_date = null, $billed_to = null, $finish_date = null, $is_finished = null, $obligatory = null, $int_status = null, $effective_fee = null)
    {
        $this
            ->setI_account_subscription($i_account_subscription)
            ->setI_subscription($i_subscription)
            ->setName($name)
            ->setDiscount_rate($discount_rate)
            ->setStart_date($start_date)
            ->setActivation_date($activation_date)
            ->setBilled_to($billed_to)
            ->setFinish_date($finish_date)
            ->setIs_finished($is_finished)
            ->setObligatory($obligatory)
            ->setInt_status($int_status)
            ->setEffective_fee($effective_fee);
    }
    /**
     * Get i_account_subscription value
     * @return int|null
     */
    public function getI_account_subscription()
    {
        return $this->i_account_subscription;
    }
    /**
     * Set i_account_subscription value
     * @param int $i_account_subscription
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setI_account_subscription($i_account_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_account_subscription) && !is_numeric($i_account_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account_subscription)), __LINE__);
        }
        $this->i_account_subscription = $i_account_subscription;
        return $this;
    }
    /**
     * Get i_subscription value
     * @return int|null
     */
    public function getI_subscription()
    {
        return $this->i_subscription;
    }
    /**
     * Set i_subscription value
     * @param int $i_subscription
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setI_subscription($i_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscription) && !is_numeric($i_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscription)), __LINE__);
        }
        $this->i_subscription = $i_subscription;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get discount_rate value
     * @return float|null
     */
    public function getDiscount_rate()
    {
        return $this->discount_rate;
    }
    /**
     * Set discount_rate value
     * @param float $discount_rate
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setDiscount_rate($discount_rate = null)
    {
        $this->discount_rate = $discount_rate;
        return $this;
    }
    /**
     * Get start_date value
     * @return string|null
     */
    public function getStart_date()
    {
        return $this->start_date;
    }
    /**
     * Set start_date value
     * @param string $start_date
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setStart_date($start_date = null)
    {
        // validation for constraint: string
        if (!is_null($start_date) && !is_string($start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_date)), __LINE__);
        }
        $this->start_date = $start_date;
        return $this;
    }
    /**
     * Get activation_date value
     * @return string|null
     */
    public function getActivation_date()
    {
        return $this->activation_date;
    }
    /**
     * Set activation_date value
     * @param string $activation_date
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setActivation_date($activation_date = null)
    {
        // validation for constraint: string
        if (!is_null($activation_date) && !is_string($activation_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activation_date)), __LINE__);
        }
        $this->activation_date = $activation_date;
        return $this;
    }
    /**
     * Get billed_to value
     * @return string|null
     */
    public function getBilled_to()
    {
        return $this->billed_to;
    }
    /**
     * Set billed_to value
     * @param string $billed_to
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setBilled_to($billed_to = null)
    {
        // validation for constraint: string
        if (!is_null($billed_to) && !is_string($billed_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billed_to)), __LINE__);
        }
        $this->billed_to = $billed_to;
        return $this;
    }
    /**
     * Get finish_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinish_date()
    {
        return isset($this->finish_date) ? $this->finish_date : null;
    }
    /**
     * Set finish_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finish_date
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setFinish_date($finish_date = null)
    {
        // validation for constraint: string
        if (!is_null($finish_date) && !is_string($finish_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finish_date)), __LINE__);
        }
        if (is_null($finish_date) || (is_array($finish_date) && empty($finish_date))) {
            unset($this->finish_date);
        } else {
            $this->finish_date = $finish_date;
        }
        return $this;
    }
    /**
     * Get is_finished value
     * @return string|null
     */
    public function getIs_finished()
    {
        return $this->is_finished;
    }
    /**
     * Set is_finished value
     * @param string $is_finished
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setIs_finished($is_finished = null)
    {
        // validation for constraint: string
        if (!is_null($is_finished) && !is_string($is_finished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_finished)), __LINE__);
        }
        $this->is_finished = $is_finished;
        return $this;
    }
    /**
     * Get obligatory value
     * @return string|null
     */
    public function getObligatory()
    {
        return $this->obligatory;
    }
    /**
     * Set obligatory value
     * @param string $obligatory
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setObligatory($obligatory = null)
    {
        // validation for constraint: string
        if (!is_null($obligatory) && !is_string($obligatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obligatory)), __LINE__);
        }
        $this->obligatory = $obligatory;
        return $this;
    }
    /**
     * Get int_status value
     * @return int|null
     */
    public function getInt_status()
    {
        return $this->int_status;
    }
    /**
     * Set int_status value
     * @param int $int_status
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setInt_status($int_status = null)
    {
        // validation for constraint: int
        if (!is_null($int_status) && !is_numeric($int_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($int_status)), __LINE__);
        }
        $this->int_status = $int_status;
        return $this;
    }
    /**
     * Get effective_fee value
     * @return float|null
     */
    public function getEffective_fee()
    {
        return $this->effective_fee;
    }
    /**
     * Set effective_fee value
     * @param float $effective_fee
     * @return \StructType\AccountSubscriptionInfo
     */
    public function setEffective_fee($effective_fee = null)
    {
        $this->effective_fee = $effective_fee;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountSubscriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
