<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resetpassword ServiceType
 * @subpackage Services
 */
class Resetpassword extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reset_password
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetPasswordRequest $resetPasswordRequest
     * @return \StructType\ResetPasswordResponse|bool
     */
    public function reset_password(\StructType\ResetPasswordRequest $resetPasswordRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->reset_password($resetPasswordRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResetPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
