<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XrateInfo StructType
 * @subpackage Structs
 */
class XrateInfo extends AbstractStructBase
{
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The base_iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $base_iso_4217;
    /**
     * The base_units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $base_units;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $is_active;
    /**
     * Constructor method for XrateInfo
     * @uses XrateInfo::setSource()
     * @uses XrateInfo::setTimestamp()
     * @uses XrateInfo::setIso_4217()
     * @uses XrateInfo::setName()
     * @uses XrateInfo::setBase_iso_4217()
     * @uses XrateInfo::setBase_units()
     * @uses XrateInfo::setIs_active()
     * @param string $source
     * @param string $timestamp
     * @param string $iso_4217
     * @param string $name
     * @param string $base_iso_4217
     * @param float $base_units
     * @param int $is_active
     */
    public function __construct($source = null, $timestamp = null, $iso_4217 = null, $name = null, $base_iso_4217 = null, $base_units = null, $is_active = null)
    {
        $this
            ->setSource($source)
            ->setTimestamp($timestamp)
            ->setIso_4217($iso_4217)
            ->setName($name)
            ->setBase_iso_4217($base_iso_4217)
            ->setBase_units($base_units)
            ->setIs_active($is_active);
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\XrateInfo
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\XrateInfo
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\XrateInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XrateInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get base_iso_4217 value
     * @return string|null
     */
    public function getBase_iso_4217()
    {
        return $this->base_iso_4217;
    }
    /**
     * Set base_iso_4217 value
     * @param string $base_iso_4217
     * @return \StructType\XrateInfo
     */
    public function setBase_iso_4217($base_iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($base_iso_4217) && !is_string($base_iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_iso_4217)), __LINE__);
        }
        $this->base_iso_4217 = $base_iso_4217;
        return $this;
    }
    /**
     * Get base_units value
     * @return float|null
     */
    public function getBase_units()
    {
        return $this->base_units;
    }
    /**
     * Set base_units value
     * @param float $base_units
     * @return \StructType\XrateInfo
     */
    public function setBase_units($base_units = null)
    {
        $this->base_units = $base_units;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \StructType\XrateInfo
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XrateInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
