<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCSubscriptionPlanInfo StructType
 * @subpackage Structs
 */
class WCSubscriptionPlanInfo extends AbstractStructBase
{
    /**
     * The i_subscription
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the subscription plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_subscription;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the subscription plan on the PortaBilling100 interface, unique in the environment, mandatory, 100 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - documentation: Managed by (reseller), read-only for an existent plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_customer;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Description of the subscription plan, 255 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The invoice_description
     * Meta informations extracted from the WSDL
     * - documentation: Invoice Line Description of the subscription plan, mandatory, 100 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $invoice_description;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - documentation: Subscription plan currency, read-only for an existent plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $iso_4217;
    /**
     * The activation_mode
     * Meta informations extracted from the WSDL
     * - documentation: Subscription Is Activated: 1 (At the given start date), 2 (Upon the account"s first usage); read-only for existent plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $activation_mode;
    /**
     * The activation_fee
     * Meta informations extracted from the WSDL
     * - documentation: Activation Fee
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $activation_fee;
    /**
     * The minimum_period
     * Meta informations extracted from the WSDL
     * - documentation: Minimum Subscription Period (months)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $minimum_period;
    /**
     * The cancel_penalty
     * Meta informations extracted from the WSDL
     * - documentation: Early Cancellation Penalty, fixed amount in plan's currency
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $cancel_penalty;
    /**
     * The cancel_penalty_prorated
     * Meta informations extracted from the WSDL
     * - documentation: Early Cancellation Penalty: 0 - Fixed, 1 - Remaining subscription charges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $cancel_penalty_prorated;
    /**
     * The charge_model
     * Meta informations extracted from the WSDL
     * - documentation: Subscription Charges Applied: 0 - Progressively, 1 - At the end of the billing period, 2 - In advance; read-only for existent plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $charge_model;
    /**
     * The rounding
     * Meta informations extracted from the WSDL
     * - documentation: Round Charged Amount (-5..5)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $rounding;
    /**
     * The advance_periods
     * Meta informations extracted from the WSDL
     * - documentation: Periods In Advance, mandatory if Subscription Charges Applied In advance; read-only for existent plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $advance_periods;
    /**
     * The fees
     * Meta informations extracted from the WSDL
     * - documentation: Array of Periodic Fee Rates for the given plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:WCSubscriptionFeeRate[]
     * - ref: soapenc:arrayType
     * @var \StructType\WCSubscriptionFeeRate[]
     */
    public $fees;
    /**
     * The charge_suspended_customers
     * Meta informations extracted from the WSDL
     * - documentation: Charge Suspended Customers: Y - yes, N - no
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $charge_suspended_customers;
    /**
     * The multiple
     * Meta informations extracted from the WSDL
     * - documentation: Can be applied more than once: Y - yes, N - no
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $multiple;
    /**
     * Constructor method for WCSubscriptionPlanInfo
     * @uses WCSubscriptionPlanInfo::setI_subscription()
     * @uses WCSubscriptionPlanInfo::setName()
     * @uses WCSubscriptionPlanInfo::setI_customer()
     * @uses WCSubscriptionPlanInfo::setDescription()
     * @uses WCSubscriptionPlanInfo::setInvoice_description()
     * @uses WCSubscriptionPlanInfo::setIso_4217()
     * @uses WCSubscriptionPlanInfo::setActivation_mode()
     * @uses WCSubscriptionPlanInfo::setActivation_fee()
     * @uses WCSubscriptionPlanInfo::setMinimum_period()
     * @uses WCSubscriptionPlanInfo::setCancel_penalty()
     * @uses WCSubscriptionPlanInfo::setCancel_penalty_prorated()
     * @uses WCSubscriptionPlanInfo::setCharge_model()
     * @uses WCSubscriptionPlanInfo::setRounding()
     * @uses WCSubscriptionPlanInfo::setAdvance_periods()
     * @uses WCSubscriptionPlanInfo::setFees()
     * @uses WCSubscriptionPlanInfo::setCharge_suspended_customers()
     * @uses WCSubscriptionPlanInfo::setMultiple()
     * @param int $i_subscription
     * @param string $name
     * @param int $i_customer
     * @param string $description
     * @param string $invoice_description
     * @param string $iso_4217
     * @param int $activation_mode
     * @param float $activation_fee
     * @param int $minimum_period
     * @param float $cancel_penalty
     * @param int $cancel_penalty_prorated
     * @param int $charge_model
     * @param int $rounding
     * @param int $advance_periods
     * @param \StructType\WCSubscriptionFeeRate[] $fees
     * @param string $charge_suspended_customers
     * @param string $multiple
     */
    public function __construct($i_subscription = null, $name = null, $i_customer = null, $description = null, $invoice_description = null, $iso_4217 = null, $activation_mode = null, $activation_fee = null, $minimum_period = null, $cancel_penalty = null, $cancel_penalty_prorated = null, $charge_model = null, $rounding = null, $advance_periods = null, array $fees = array(), $charge_suspended_customers = null, $multiple = null)
    {
        $this
            ->setI_subscription($i_subscription)
            ->setName($name)
            ->setI_customer($i_customer)
            ->setDescription($description)
            ->setInvoice_description($invoice_description)
            ->setIso_4217($iso_4217)
            ->setActivation_mode($activation_mode)
            ->setActivation_fee($activation_fee)
            ->setMinimum_period($minimum_period)
            ->setCancel_penalty($cancel_penalty)
            ->setCancel_penalty_prorated($cancel_penalty_prorated)
            ->setCharge_model($charge_model)
            ->setRounding($rounding)
            ->setAdvance_periods($advance_periods)
            ->setFees($fees)
            ->setCharge_suspended_customers($charge_suspended_customers)
            ->setMultiple($multiple);
    }
    /**
     * Get i_subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_subscription()
    {
        return isset($this->i_subscription) ? $this->i_subscription : null;
    }
    /**
     * Set i_subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_subscription
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setI_subscription($i_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscription) && !is_numeric($i_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscription)), __LINE__);
        }
        if (is_null($i_subscription) || (is_array($i_subscription) && empty($i_subscription))) {
            unset($this->i_subscription);
        } else {
            $this->i_subscription = $i_subscription;
        }
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_customer()
    {
        return isset($this->i_customer) ? $this->i_customer : null;
    }
    /**
     * Set i_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_customer
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        if (is_null($i_customer) || (is_array($i_customer) && empty($i_customer))) {
            unset($this->i_customer);
        } else {
            $this->i_customer = $i_customer;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get invoice_description value
     * @return string|null
     */
    public function getInvoice_description()
    {
        return $this->invoice_description;
    }
    /**
     * Set invoice_description value
     * @param string $invoice_description
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setInvoice_description($invoice_description = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_description) && !is_string($invoice_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_description)), __LINE__);
        }
        $this->invoice_description = $invoice_description;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get activation_mode value
     * @return int|null
     */
    public function getActivation_mode()
    {
        return $this->activation_mode;
    }
    /**
     * Set activation_mode value
     * @param int $activation_mode
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setActivation_mode($activation_mode = null)
    {
        // validation for constraint: int
        if (!is_null($activation_mode) && !is_numeric($activation_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activation_mode)), __LINE__);
        }
        $this->activation_mode = $activation_mode;
        return $this;
    }
    /**
     * Get activation_fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getActivation_fee()
    {
        return isset($this->activation_fee) ? $this->activation_fee : null;
    }
    /**
     * Set activation_fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $activation_fee
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setActivation_fee($activation_fee = null)
    {
        if (is_null($activation_fee) || (is_array($activation_fee) && empty($activation_fee))) {
            unset($this->activation_fee);
        } else {
            $this->activation_fee = $activation_fee;
        }
        return $this;
    }
    /**
     * Get minimum_period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimum_period()
    {
        return isset($this->minimum_period) ? $this->minimum_period : null;
    }
    /**
     * Set minimum_period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimum_period
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setMinimum_period($minimum_period = null)
    {
        // validation for constraint: int
        if (!is_null($minimum_period) && !is_numeric($minimum_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimum_period)), __LINE__);
        }
        if (is_null($minimum_period) || (is_array($minimum_period) && empty($minimum_period))) {
            unset($this->minimum_period);
        } else {
            $this->minimum_period = $minimum_period;
        }
        return $this;
    }
    /**
     * Get cancel_penalty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCancel_penalty()
    {
        return isset($this->cancel_penalty) ? $this->cancel_penalty : null;
    }
    /**
     * Set cancel_penalty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cancel_penalty
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setCancel_penalty($cancel_penalty = null)
    {
        if (is_null($cancel_penalty) || (is_array($cancel_penalty) && empty($cancel_penalty))) {
            unset($this->cancel_penalty);
        } else {
            $this->cancel_penalty = $cancel_penalty;
        }
        return $this;
    }
    /**
     * Get cancel_penalty_prorated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCancel_penalty_prorated()
    {
        return isset($this->cancel_penalty_prorated) ? $this->cancel_penalty_prorated : null;
    }
    /**
     * Set cancel_penalty_prorated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cancel_penalty_prorated
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setCancel_penalty_prorated($cancel_penalty_prorated = null)
    {
        // validation for constraint: int
        if (!is_null($cancel_penalty_prorated) && !is_numeric($cancel_penalty_prorated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cancel_penalty_prorated)), __LINE__);
        }
        if (is_null($cancel_penalty_prorated) || (is_array($cancel_penalty_prorated) && empty($cancel_penalty_prorated))) {
            unset($this->cancel_penalty_prorated);
        } else {
            $this->cancel_penalty_prorated = $cancel_penalty_prorated;
        }
        return $this;
    }
    /**
     * Get charge_model value
     * @return int|null
     */
    public function getCharge_model()
    {
        return $this->charge_model;
    }
    /**
     * Set charge_model value
     * @param int $charge_model
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setCharge_model($charge_model = null)
    {
        // validation for constraint: int
        if (!is_null($charge_model) && !is_numeric($charge_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($charge_model)), __LINE__);
        }
        $this->charge_model = $charge_model;
        return $this;
    }
    /**
     * Get rounding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRounding()
    {
        return isset($this->rounding) ? $this->rounding : null;
    }
    /**
     * Set rounding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rounding
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setRounding($rounding = null)
    {
        // validation for constraint: int
        if (!is_null($rounding) && !is_numeric($rounding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rounding)), __LINE__);
        }
        if (is_null($rounding) || (is_array($rounding) && empty($rounding))) {
            unset($this->rounding);
        } else {
            $this->rounding = $rounding;
        }
        return $this;
    }
    /**
     * Get advance_periods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAdvance_periods()
    {
        return isset($this->advance_periods) ? $this->advance_periods : null;
    }
    /**
     * Set advance_periods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $advance_periods
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setAdvance_periods($advance_periods = null)
    {
        // validation for constraint: int
        if (!is_null($advance_periods) && !is_numeric($advance_periods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($advance_periods)), __LINE__);
        }
        if (is_null($advance_periods) || (is_array($advance_periods) && empty($advance_periods))) {
            unset($this->advance_periods);
        } else {
            $this->advance_periods = $advance_periods;
        }
        return $this;
    }
    /**
     * Get fees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WCSubscriptionFeeRate[]|null
     */
    public function getFees()
    {
        return isset($this->fees) ? $this->fees : null;
    }
    /**
     * Set fees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WCSubscriptionFeeRate[] $fees
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setFees(array $fees = array())
    {
        foreach ($fees as $wCSubscriptionPlanInfoFeesItem) {
            // validation for constraint: itemType
            if (!$wCSubscriptionPlanInfoFeesItem instanceof \StructType\WCSubscriptionFeeRate) {
                throw new \InvalidArgumentException(sprintf('The fees property can only contain items of \StructType\WCSubscriptionFeeRate, "%s" given', is_object($wCSubscriptionPlanInfoFeesItem) ? get_class($wCSubscriptionPlanInfoFeesItem) : gettype($wCSubscriptionPlanInfoFeesItem)), __LINE__);
            }
        }
        if (is_null($fees) || (is_array($fees) && empty($fees))) {
            unset($this->fees);
        } else {
            $this->fees = $fees;
        }
        return $this;
    }
    /**
     * Add item to fees value
     * @throws \InvalidArgumentException
     * @param \StructType\WCSubscriptionFeeRate $item
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function addToFees(\StructType\WCSubscriptionFeeRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WCSubscriptionFeeRate) {
            throw new \InvalidArgumentException(sprintf('The fees property can only contain items of \StructType\WCSubscriptionFeeRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->fees[] = $item;
        return $this;
    }
    /**
     * Get charge_suspended_customers value
     * @return string|null
     */
    public function getCharge_suspended_customers()
    {
        return $this->charge_suspended_customers;
    }
    /**
     * Set charge_suspended_customers value
     * @param string $charge_suspended_customers
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setCharge_suspended_customers($charge_suspended_customers = null)
    {
        // validation for constraint: string
        if (!is_null($charge_suspended_customers) && !is_string($charge_suspended_customers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charge_suspended_customers)), __LINE__);
        }
        $this->charge_suspended_customers = $charge_suspended_customers;
        return $this;
    }
    /**
     * Get multiple value
     * @return string|null
     */
    public function getMultiple()
    {
        return $this->multiple;
    }
    /**
     * Set multiple value
     * @param string $multiple
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public function setMultiple($multiple = null)
    {
        // validation for constraint: string
        if (!is_null($multiple) && !is_string($multiple)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multiple)), __LINE__);
        }
        $this->multiple = $multiple;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCSubscriptionPlanInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
