<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCSubscriptionInfo StructType
 * @subpackage Structs
 */
class WCSubscriptionInfo extends AbstractStructBase
{
    /**
     * The i_obj_subscription
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the subscription record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_obj_subscription;
    /**
     * The object_type
     * Meta informations extracted from the WSDL
     * - documentation: Type of the object the subscription is assigned to: customer, account
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $object_type;
    /**
     * The i_object
     * Meta informations extracted from the WSDL
     * - documentation: ID of the account/customer object the subscription is assigned to
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_object;
    /**
     * The i_subscription
     * Meta informations extracted from the WSDL
     * - documentation: ID of the subscription plan
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_subscription;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the subscription plan
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The discount_rate
     * Meta informations extracted from the WSDL
     * - documentation: Amount of discount applied to the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $discount_rate;
    /**
     * The start_date
     * Meta informations extracted from the WSDL
     * - documentation: Start date of the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $start_date;
    /**
     * The activation_date
     * Meta informations extracted from the WSDL
     * - documentation: Activation date of the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $activation_date;
    /**
     * The billed_to
     * Meta informations extracted from the WSDL
     * - documentation: Billed To date of the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $billed_to;
    /**
     * The finish_date
     * Meta informations extracted from the WSDL
     * - documentation: Finish date of the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $finish_date;
    /**
     * The is_finished
     * Meta informations extracted from the WSDL
     * - documentation: Is subscription finished: Y - yes, N - no
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $is_finished;
    /**
     * The int_status
     * Meta informations extracted from the WSDL
     * - documentation: Internal status of the subscription
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $int_status;
    /**
     * The last_refund_date
     * Meta informations extracted from the WSDL
     * - documentation: Date of last refund
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $last_refund_date;
    /**
     * The expected_bill_time
     * Meta informations extracted from the WSDL
     * - documentation: Expected next billing time
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $expected_bill_time;
    /**
     * The invoice_description
     * Meta informations extracted from the WSDL
     * - documentation: The subscription plan name as the end-user will see it on the invoice
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $invoice_description;
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - documentation: ID of the product within which this subscription was defined
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_product;
    /**
     * Constructor method for WCSubscriptionInfo
     * @uses WCSubscriptionInfo::setI_obj_subscription()
     * @uses WCSubscriptionInfo::setObject_type()
     * @uses WCSubscriptionInfo::setI_object()
     * @uses WCSubscriptionInfo::setI_subscription()
     * @uses WCSubscriptionInfo::setName()
     * @uses WCSubscriptionInfo::setDiscount_rate()
     * @uses WCSubscriptionInfo::setStart_date()
     * @uses WCSubscriptionInfo::setActivation_date()
     * @uses WCSubscriptionInfo::setBilled_to()
     * @uses WCSubscriptionInfo::setFinish_date()
     * @uses WCSubscriptionInfo::setIs_finished()
     * @uses WCSubscriptionInfo::setInt_status()
     * @uses WCSubscriptionInfo::setLast_refund_date()
     * @uses WCSubscriptionInfo::setExpected_bill_time()
     * @uses WCSubscriptionInfo::setInvoice_description()
     * @uses WCSubscriptionInfo::setI_product()
     * @param int $i_obj_subscription
     * @param string $object_type
     * @param int $i_object
     * @param int $i_subscription
     * @param string $name
     * @param float $discount_rate
     * @param string $start_date
     * @param string $activation_date
     * @param string $billed_to
     * @param string $finish_date
     * @param string $is_finished
     * @param int $int_status
     * @param string $last_refund_date
     * @param string $expected_bill_time
     * @param string $invoice_description
     * @param int $i_product
     */
    public function __construct($i_obj_subscription = null, $object_type = null, $i_object = null, $i_subscription = null, $name = null, $discount_rate = null, $start_date = null, $activation_date = null, $billed_to = null, $finish_date = null, $is_finished = null, $int_status = null, $last_refund_date = null, $expected_bill_time = null, $invoice_description = null, $i_product = null)
    {
        $this
            ->setI_obj_subscription($i_obj_subscription)
            ->setObject_type($object_type)
            ->setI_object($i_object)
            ->setI_subscription($i_subscription)
            ->setName($name)
            ->setDiscount_rate($discount_rate)
            ->setStart_date($start_date)
            ->setActivation_date($activation_date)
            ->setBilled_to($billed_to)
            ->setFinish_date($finish_date)
            ->setIs_finished($is_finished)
            ->setInt_status($int_status)
            ->setLast_refund_date($last_refund_date)
            ->setExpected_bill_time($expected_bill_time)
            ->setInvoice_description($invoice_description)
            ->setI_product($i_product);
    }
    /**
     * Get i_obj_subscription value
     * @return int
     */
    public function getI_obj_subscription()
    {
        return $this->i_obj_subscription;
    }
    /**
     * Set i_obj_subscription value
     * @param int $i_obj_subscription
     * @return \StructType\WCSubscriptionInfo
     */
    public function setI_obj_subscription($i_obj_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_obj_subscription) && !is_numeric($i_obj_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_obj_subscription)), __LINE__);
        }
        $this->i_obj_subscription = $i_obj_subscription;
        return $this;
    }
    /**
     * Get object_type value
     * @return string
     */
    public function getObject_type()
    {
        return $this->object_type;
    }
    /**
     * Set object_type value
     * @param string $object_type
     * @return \StructType\WCSubscriptionInfo
     */
    public function setObject_type($object_type = null)
    {
        // validation for constraint: string
        if (!is_null($object_type) && !is_string($object_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object_type)), __LINE__);
        }
        $this->object_type = $object_type;
        return $this;
    }
    /**
     * Get i_object value
     * @return int
     */
    public function getI_object()
    {
        return $this->i_object;
    }
    /**
     * Set i_object value
     * @param int $i_object
     * @return \StructType\WCSubscriptionInfo
     */
    public function setI_object($i_object = null)
    {
        // validation for constraint: int
        if (!is_null($i_object) && !is_numeric($i_object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_object)), __LINE__);
        }
        $this->i_object = $i_object;
        return $this;
    }
    /**
     * Get i_subscription value
     * @return int
     */
    public function getI_subscription()
    {
        return $this->i_subscription;
    }
    /**
     * Set i_subscription value
     * @param int $i_subscription
     * @return \StructType\WCSubscriptionInfo
     */
    public function setI_subscription($i_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscription) && !is_numeric($i_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscription)), __LINE__);
        }
        $this->i_subscription = $i_subscription;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCSubscriptionInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get discount_rate value
     * @return float
     */
    public function getDiscount_rate()
    {
        return $this->discount_rate;
    }
    /**
     * Set discount_rate value
     * @param float $discount_rate
     * @return \StructType\WCSubscriptionInfo
     */
    public function setDiscount_rate($discount_rate = null)
    {
        $this->discount_rate = $discount_rate;
        return $this;
    }
    /**
     * Get start_date value
     * @return string
     */
    public function getStart_date()
    {
        return $this->start_date;
    }
    /**
     * Set start_date value
     * @param string $start_date
     * @return \StructType\WCSubscriptionInfo
     */
    public function setStart_date($start_date = null)
    {
        // validation for constraint: string
        if (!is_null($start_date) && !is_string($start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_date)), __LINE__);
        }
        $this->start_date = $start_date;
        return $this;
    }
    /**
     * Get activation_date value
     * @return string
     */
    public function getActivation_date()
    {
        return $this->activation_date;
    }
    /**
     * Set activation_date value
     * @param string $activation_date
     * @return \StructType\WCSubscriptionInfo
     */
    public function setActivation_date($activation_date = null)
    {
        // validation for constraint: string
        if (!is_null($activation_date) && !is_string($activation_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activation_date)), __LINE__);
        }
        $this->activation_date = $activation_date;
        return $this;
    }
    /**
     * Get billed_to value
     * @return string
     */
    public function getBilled_to()
    {
        return $this->billed_to;
    }
    /**
     * Set billed_to value
     * @param string $billed_to
     * @return \StructType\WCSubscriptionInfo
     */
    public function setBilled_to($billed_to = null)
    {
        // validation for constraint: string
        if (!is_null($billed_to) && !is_string($billed_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billed_to)), __LINE__);
        }
        $this->billed_to = $billed_to;
        return $this;
    }
    /**
     * Get finish_date value
     * @return string
     */
    public function getFinish_date()
    {
        return $this->finish_date;
    }
    /**
     * Set finish_date value
     * @param string $finish_date
     * @return \StructType\WCSubscriptionInfo
     */
    public function setFinish_date($finish_date = null)
    {
        // validation for constraint: string
        if (!is_null($finish_date) && !is_string($finish_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finish_date)), __LINE__);
        }
        $this->finish_date = $finish_date;
        return $this;
    }
    /**
     * Get is_finished value
     * @return string
     */
    public function getIs_finished()
    {
        return $this->is_finished;
    }
    /**
     * Set is_finished value
     * @param string $is_finished
     * @return \StructType\WCSubscriptionInfo
     */
    public function setIs_finished($is_finished = null)
    {
        // validation for constraint: string
        if (!is_null($is_finished) && !is_string($is_finished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_finished)), __LINE__);
        }
        $this->is_finished = $is_finished;
        return $this;
    }
    /**
     * Get int_status value
     * @return int
     */
    public function getInt_status()
    {
        return $this->int_status;
    }
    /**
     * Set int_status value
     * @param int $int_status
     * @return \StructType\WCSubscriptionInfo
     */
    public function setInt_status($int_status = null)
    {
        // validation for constraint: int
        if (!is_null($int_status) && !is_numeric($int_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($int_status)), __LINE__);
        }
        $this->int_status = $int_status;
        return $this;
    }
    /**
     * Get last_refund_date value
     * @return string
     */
    public function getLast_refund_date()
    {
        return $this->last_refund_date;
    }
    /**
     * Set last_refund_date value
     * @param string $last_refund_date
     * @return \StructType\WCSubscriptionInfo
     */
    public function setLast_refund_date($last_refund_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_refund_date) && !is_string($last_refund_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_refund_date)), __LINE__);
        }
        $this->last_refund_date = $last_refund_date;
        return $this;
    }
    /**
     * Get expected_bill_time value
     * @return string
     */
    public function getExpected_bill_time()
    {
        return $this->expected_bill_time;
    }
    /**
     * Set expected_bill_time value
     * @param string $expected_bill_time
     * @return \StructType\WCSubscriptionInfo
     */
    public function setExpected_bill_time($expected_bill_time = null)
    {
        // validation for constraint: string
        if (!is_null($expected_bill_time) && !is_string($expected_bill_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expected_bill_time)), __LINE__);
        }
        $this->expected_bill_time = $expected_bill_time;
        return $this;
    }
    /**
     * Get invoice_description value
     * @return string
     */
    public function getInvoice_description()
    {
        return $this->invoice_description;
    }
    /**
     * Set invoice_description value
     * @param string $invoice_description
     * @return \StructType\WCSubscriptionInfo
     */
    public function setInvoice_description($invoice_description = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_description) && !is_string($invoice_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_description)), __LINE__);
        }
        $this->invoice_description = $invoice_description;
        return $this;
    }
    /**
     * Get i_product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_product()
    {
        return isset($this->i_product) ? $this->i_product : null;
    }
    /**
     * Set i_product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_product
     * @return \StructType\WCSubscriptionInfo
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        if (is_null($i_product) || (is_array($i_product) && empty($i_product))) {
            unset($this->i_product);
        } else {
            $this->i_product = $i_product;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCSubscriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
